#ifdef RCS
static char rcsid[]="$Id: country.c,v 1.1.1.1 2000/11/13 02:42:40 holsta dancer.c $";
#endif
/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/country.c,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:40 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#include "dancer.h"
#include "trio.h"
#include "strio.h"
#include "function.h"
#include "user.h"
#include "transfer.h"
#include "country.h"

/* --- Global ----------------------------------------------------- */

char *continents[7] = {
  "Europe",
  "Asia",
  "Africa",
  "Australia",
  "North America",
  "South America",
  "Antarctica"
};

land countries[] = {
  {eu, "ad", "Andorra",        "Les Valls d'Andorr"},
  {as, "ae", "Arab Emirates",  "(United Arab Emirates) Al-Imarat Al'Arabiya Al-Muttahida", "Dirham", "AED"},
  {as, "af", "Afghanistan",    "Jamhuria Afghanistan / Dowlat-e Eslami-ye Afghanestan", "Afghani", "AFA"},
  {sa, "ag", "Artigua",        "Artigua-Barbuda"},
  {as, "ai", "Anguilla",       "", "Dollar", "AID"},
  {eu, "al", "Albania",        "Republika e Shqipris", "Lek", "ALL"},
  {as, "am", "Armenia",        "Haikakan", "Dram", "AMD"},
  {as, "an", "Antilles",       "(Netherlands Antilles)", "Guilder", "ANG"},
  {af, "ao", "Angola",         "A Repblica de Angola", "Kwanza Reajustado", "AOK"},
  {an, "aq", "Antarctica",     "Antarctica"},
  {sa, "ar", "Argentina",      "Repblica Argentina", "Peso", "ARP"},
  {sa, "as", "American Samoa", "American Samoa"},
  {eu, "at", "Austria",        "Republik sterreich", "Schilling", "ATS"},
  {au, "au", "Australia",      "The Commonwealth of Australia", "Dollar", "AUD"},
  {sa, "aw", "Aruba",          "Aruba"},
  {eu, "az", "Azerbaijan",     "Azarbaijchan", "Mana", "AZM"},
  {eu, "ba", "Bosnia",         "Bosna i Hercegovina", "Dinar", "BAD"},
  {sa, "bb", "Barbados",       "Barbados", "Dollar", "BBD"},
  {as, "bd", "Bangladesh",     "Gana Praja Tantri Bangla Desh", "Taka", "BDT"},
  {eu, "be", "Belgium",        "Royaume de Belgique / Koninkrijk Belgi", "Franc", "BEF"},
  {af, "bf", "Burkina Faso",   "Burkina Faso / Rpublique de Burkina", "Franc", "BFF"},
  {eu, "bg", "Bulgaria",       "Republika Bulgariya", "Lev", "BGL"},
  {as, "bh", "Bahrain",        "Daulat al-Bahrain", "Dinar", "BHD"},
  {as, "bi", "Burundi",        "La Rpublique du Burundi / Republika y'Uburundi", "Franc", "BIR"},
  {af, "bj", "Benin",          "La Rplublique du Bnin", "Franc", "BJF"},
  {sa, "bm", "Bermuda",        "Bermuda (British)", "Dollar", "BMD"},
  {as, "bn", "Brunei",         "Negara Brunei Darussalam", "Dollar", "BND"},
  {sa, "bo", "Bolivia",        "Rpublica de Bolivia", "Bolivianos", "BOB"},
  {sa, "br", "Brazil",         "A Repblica Federativa do Brasil", "Real", "BRC"},
  {sa, "bs", "Bahamas",        "The Commonwealth of Bahamas", "Dollar", "BSD"},
  {as, "bt", "Bhutan",         "Druk-yul", "Ngultrum", "BTN"},
  {eu, "bv", "Bouvet",         "(Bouvet Island)"},
  {af, "bw", "Botswana",       "Republic of Botswana", "Pula", "BWP"},
  {as, "by", "Belarus",        "Republika Belarus", "Ruble", "BYR"},
  {sa, "bz", "Belize",         "Belize", "Dollar", "BZD"},
  {na, "ca", "Canada",         "Canada", "Dollar", "CAD"},
  {sa, "cc", "Cocos",          "Territory of Cocos (Keeling) Islands"},
  {af, "cd", "Congo",          "The Democratic Republic of Congo"},
  {af, "cf", "Central African", "La Rpublique Centrafricaine", "Franc", "CFF"},
  {af, "cg", "Congo",          "La Rpublique populaire du Congo", "Franc", "CGF"},
  {eu, "ch", "Switzerland",    "Schweizerische Eidgenoenschaft / Confdration Suisse / Confederazione Svizzera / Confederaziun Helvetica", "Franc", "CHF"},
  {af, "ci", "Cote D'Ivoire",  "La Rpublique de la Cte d'Ivoire", "Franc", "CIF"},
  {af, "ck", "Cook",           "(Cook Islands)", "Dollar", "CKD"},
  {sa, "cl", "Chile",          "Repblica de Chile", "Pesos", "CLP"},
  {af, "cm", "Cameroon",       "La Rpublique unie du Cameroun", "Franc", "CMF"},
  {as, "cn", "China",          "Zhonghua Renmin Gongheguo", "Yuan", "CNY"},
  {sa, "co", "Colombia",       "La Repblica de Colombia", "Peso", "COP"},
  {sa, "cr", "Costa Rica",     "Repblica de Costa Rica", "Colone", "CRC"},
  {eu, "cs", "Czechoslovakia", "Czechoslovakia"},
  {sa, "cu", "Cuba",           "La Repblica de Cuba", "Peso", "CUP"},
  {af, "cv", "Cape Verde",     "A Repblica de Cabo Verde", "Escudo", "CVE"},
  {sa, "cx", "Christmas",      "Territory of Christmas Island"},
  {eu, "cy", "Cyprus",         "Kypriaki Dimokratia / Kibris Cumhuriyeti", "Pound", "CYP"},
  {eu, "cz", "Czech",          "(Czech Republic) Cesk Republika", "Korouna", "CSK"},
  {eu, "de", "Germany",        "Bundesrepublik Deutschland", "Mark", "DEM"},
  {af, "dj", "Djibouti",       "Jumhuriya Djibuti", "Franc", "DJF"},
  {eu, "dk", "Denmark",        "Kongeriget Danmark", "Krone", "DKK"},
  {sa, "dm", "Dominica",       "Commonwealth of Dominica", "Dollar", "DMD"},
  {sa, "do", "Dominican Republic", "Repblica Dominicana", "Peso", "DOP"},
  {af, "dz", "Algeria",        "El Djemhouria El Djazaria Demokratia Echaabia", "Dinar", "DZD"},
  {sa, "ec", "Ecuador",        "Repblica del Ecuador", "Sucre", "ECS"},
  {eu, "ee", "Estonia",        "Eesti Vabariik", "Kroon", "EEK"},
  {af, "eg", "Egypt",          "Jumhuriyat Misr al'Arabiya", "Pound", "EGP"},
  {af, "eh", "Western Sahara", "Western Sahara"},
  {eu, "es", "Spain",          "Reino de Espaa", "Peseta", "ESP"},
  {af, "et", "Ethiopia",       "Ityopia", "Birr", "ETB"},
  {eu, "fi", "Finland",        "Suomen Tasavalta", "Markka", "FIM"},
  {as, "fj", "Fiji",           "Matanitu Ko Viti", "Dollar", "FJD"},
  {sa, "fk", "Falkland",       "Falkland Islands (Malvinas)"},
  {as, "fm", "Micronesia",     "The Federated States of Micronesia"},
  {eu, "fo", "Faroe",          "(Faroe Islands) Froyar"},
  {eu, "fr", "France",         "La Rpublique Franaise", "Franc", "FRF"},
  {eu, "fx", "Metropolitan",   "France Metropolitan"},
  {af, "ga", "Gabon",          "La Rpublique Gabonaise", "Franc", "GAF"},
  {eu, "gb", "Great Britain",  "The United Kingdom of Great Britain and Northern Ireland", "Pound", "UKP"},
  {sa, "gd", "Grenada",        "Grenada", "Dollar", "GDD"},
  {as, "ge", "Georgia",        "Sakartvelo / Sakartvelos Respublica", "Lari", "GEL"},
  {af, "gf", "Guiana",         "Guyane (French Guiana)", "Franc", "GFF"},
  {af, "gh", "Ghana",          "Republic of Ghana", "Cedi", "GHC"},
  {eu, "gi", "Gibraltar",      ""},
  {eu, "gl", "Greenland",      "Kalaallit Nunaat"},
  {af, "gm", "Gambia",         "Republic of The Gambia", "Dalasi", "GMD"},
  {af, "gn", "Guinea",         "La Rpublique de Guine"},
  {af, "gp", "Guadeloupe",     "Guadeloupe (French)", "Franc", "GPF"},
  {af, "gq", "Equatorial Guinea", "La Repblica de Guinea Ecuatorial", "Franc", "GQF"},
  {eu, "gr", "Greece",         "Elleniki Dimocrtia / Ells", "Drachma", "GRD"},
  {sa, "gt", "Guatemala",      "Repblica de Guatemala", "Quetzale", "GTQ"},
  {af, "gu", "Guam",           "Territory of Guam"},
  {af, "gw", "Guinea-Bissau",  "Republica da Guin-Bissau", "Peso", "GWP"},
  {af, "gy", "Guyana",         "The Cooperative Republic of Guyana", "Dollar", "GYD"},
  {as, "hk", "Hong Kong",      "Hong Kong (British)", "Dollar", "HKD"},
  {as, "hm", "Heard, Mc Donald", "Heard and Mc Donald Islands"},
  {sa, "hn", "Honduras",       "La Repblica de Honduras", "Lempira", "HNL"},
  {eu, "hr", "Croatia",        "Republika Hrvatska", "Kuna", "HRK"},
  {sa, "ht", "Haiti",          "La Rpublique d'Haiti", "Gourde", "HTG"},
  {eu, "hu", "Hungary",        "Magyarorszg / Magyar Kztrssag", "Forint", "HUF"},
  {as, "id", "Indonesia",      "Republik Indonesia", "Rupiah", "IDR"},
  {eu, "ie", "Ireland",        "Poblacht na h'ireann", "Pound", "IEP"},
  {as, "il", "Israel",         "Medinat Israel", "Shekel", "ILS"},
  {as, "in", "India",          "Bharat", "Rupee", "INR"},
  {as, "io", "Indian Ocean",   "British Indian Ocean Territory"},
  {as, "iq", "Iraq",           "Al-Jumhuriya al'Iraqiya", "Dinar", "IQD"},
  {as, "ir", "Iran",           "Jomhori-e-Islami-e-Irn", "Rial", "IRR"},
  {eu, "is", "Iceland",        "Lveldi sland", "Krna", "ISK"},
  {eu, "it", "Italy",          "Italia / Repubblica Italiana", "Lira", "ITL"},
  {sa, "jm", "Jamaica",        "Jamaica", "Dollar", "JMD"},
  {as, "jo", "Jordan",         "Al-Mamlaka al-Urduniya al-Hashemiyah", "Dinar", "JOD"},
  {as, "jp", "Japan",          "Nippon / Nihon", "Yen", "JPY"},
  {af, "ke", "Kenya",          "Jamhuri ya Kenya", "Shilling", "KES"},
  {as, "kg", "Kyrgyzstan",     "Kyrgyzstan", "Som", "KGS"},
  {as, "kh", "Cambodia",       "Roat Kampuchea", "Riel", "KHR"},
  {as, "ki", "Kiribati",       "Republic of Kiribati", "Dollar", "AUD"}, /* Australian dollars */
  {as, "km", "Comoros",        "La Rpublique fdrale islamique des Comores", "Franc", "KMF"},
  {as, "kn", "Saint Kitts",    "The Federation of Saint Christopher and Nevis", "Dollar", "KND"},
  {as, "kp", "North Korea",    "Chosun Mincho-chui Inmin Konghwaguk", "Won", "KPW"},
  {as, "kr", "South Korea",    "Daehan-Minuk", "Won", "KRW"},
  {as, "kw", "Kuwait",         "Dowlat al-Kuwait", "Dinar", "KWD"},
  {as, "ky", "Cayman",         "(Cayman Island)", "Dollar", "KYD"},
  {as, "kz", "Kazakhstan",     "Kazak Respublikasy", "Tenge", "KZT"},
  {as, "la", "Lao",            "Saathiaranagroat Prachhathippatay Prachhachhon Lao", "Kip", "LAK"},
  {as, "lb", "Lebanon",        "Al-Lubnan", "Pound", "LBP"},
  {as, "lc", "Saint Lucia",    "Saint Lucia", "Dollar", "LCD"},
  {eu, "li", "Liechtenstein",  "Frstentum Liechtenstein"},
  {as, "lk", "Sri Lanka",      "Sri Lanka Prajatantrika Samajawadi Janarajaya", "Rupee", "LKR"},
  {af, "lr", "Liberia",        "The Republic of Liberia", "Dollar", "LRD"},
  {af, "ls", "Lesotho",        "The Kingdom of Lesotho", "Maloti", "LSM"},
  {eu, "lt", "Lithuania",      "Lietuva", "Litai", "LTL"},
  {eu, "lu", "Luxembourg",     "Grand-Duch de Luxembourg", "Franc", "LUF"},
  {eu, "lv", "Latvia",         "Latvija", "Lat", "LVL"},
  {af, "ly", "Libyan",         "Daulat Libiya al'Arabiya al-Ishtrakiya al-Jumhuriya", "Dinar", "LYD"},
  {af, "ma", "Morocco",        "Al-Mamlaka al-Maghribiya", "Dirham", "MAD"},
  {eu, "mc", "Monaco",         "Principaut de Monaco", "Franc", "MCF"},
  {eu, "md", "Moldova",        "Republica Moldoveneaca", "Leu", "MDL"},
  {af, "mg", "Madagascar",     "Repoblika Demokratika n'i Madagaskar", "Franc", "MGF"},
  {as, "mh", "Marshall",       "The Republic of the Marshall Islands"},
  {eu, "mk", "Macedonia",      "Republika Makedonija", "Denar", "MKD"},
  {af, "ml", "Mali",           "La Rpublique du Mali", "Franc", "MLF"},
  {af, "mm", "Myanmar",        "Myanmar Naingngandaw", "Kyat", "MMK"},
  {as, "mn", "Mongolia",       "Mongol Uls", "Tughrik", "MNT"},
  {as, "mo", "Macau",          "Ilha de Macau", "Pataca", "MOP"},
  {as, "mp", "Mariana",        "Northern Mariana Islands"},
  {af, "mq", "Martinique",     "Martinique (French)", "Franc", "MQF"},
  {af, "mr", "Mauritania",     "Jumhuriyat Muritaniya al-Islamiya", "Ouguiya", "MRO"},
  {af, "ms", "Montserrat",     "Montserrat (British)", "Dollar", "MSD"},
  {eu, "mt", "Malta",          "Repubblika Ta'Malta", "Lira", "MTL"},
  {af, "mu", "Mauritius",      "Republic of Mauritius", "Rupee", "MUR"},
  {as, "mv", "Maldives",       "Dhivehi Jumburiya", "Rufiyaa", "MVR"},
  {af, "mw", "Malawi",         "The Republic of Malawi", "Kwacha", "MWK"},
  {na, "mx", "Mexico",         "Estados Unidos Mxicanos", "Peso", "MXP"},
  {as, "my", "Malaysia",       "Persekutuan Tanah Melaysiu", "Ringgit", "MYR"},
  {af, "mz", "Mozambique",     "A Repblica de Moambique", "Metical", "MZM"},
  {af, "na", "Namibia",        "The Republic of Namibia / Republiek van Namibie", "Dollar", "NAD"},
  {au, "nc", "New Caledonia",  "Territoire des Nouvelle-Caledonie et Dependances", "Franc", "NCF"},
  {af, "ne", "Niger",          "La Rpublique du Niger", "Franc", "NEF"},
  {eu, "nf", "Norfolk",        "Territory of Norfolk Island"},
  {af, "ng", "Nigeria",        "The Federal Republic of Nigeria", "Naira", "NGN"},
  {sa, "ni", "Nicaragua",      "Repblica de Nicaragua", "Cordoba", "NIC"},
  {eu, "nl", "Netherlands",    "Koninkrijk der Nederlanden (Holland)", "Guilder", "NLG"},
  {eu, "no", "Norway",         "Kongeriket Norge", "Krone", "NOK"},
  {as, "np", "Nepal",          "Nepal Adhirajya", "Rupee", "NPR"},
  {af, "nr", "Nauru",          "The Republic of Nauru", "Dollar", "AUD"}, /* australian dollars */
  {as, "nt", "Neutral Zone",   ""},
  {af, "nu", "Niue",           "Niue", "Dollar", "NZD"}, /* New Zealand Dollars */
  {au, "nz", "New Zealand",    "Dominion of New Zealand", "Dollar", "NZD"},
  {as, "om", "Oman",           "Sultanat 'Uman'", "Rial Omani", "OMR"},
  {sa, "pa", "Panama",         "La Repblica de Panam", "Balboa", "PAB"},
  {sa, "pe", "Peru",           "Repblica del Per", "Nuevo Sol", "PES"},
  {as, "pf", "French Polynesia", "Territory de la Polynesie Francaise"},
  {as, "pg", "Papua",          "The Independent State of Papua New Guinea", "Kina", "PGK"},
  {as, "ph", "Philippines",    "Repblika fig Pilipinas", "Pesos", "PHP"},
  {as, "pk", "Pakistan",       "Islami Jamhuria-e-Pakistan", "Rupee", "PKR"},
  {eu, "pl", "Poland",         "Polska Rzecpospolita", "Zloty", "PLZ"},
  {eu, "pm", "St. Pierre, Miquelon", "Departement de Saint-Pierre et Miquelon"},
  {as, "pn", "Pitcairn",       "Pitcairn, Henderson, Ducie, and Oeno Islands"},
  {sa, "pr", "Puerto Rico",    "Commonwealth of Puerto Rico"},
  {eu, "pt", "Portugal",       "A Repblica Portuguesa", "Escudo", "PTE"},
  {as, "pw", "Palau",          "Republic of Palau"},
  {sa, "py", "Paraguay",       "La Repblica del Paraguay", "Guranie", "PYG"},
  {as, "qa", "Qatar",          "Dawlat Qatar", "Riyal", "QAR"},
  {af, "re", "Reunion",        "Runion (French)"},
  {eu, "ro", "Romania",        "Rmania", "Leu", "ROL"},
  {eu, "ru", "Russia",         "Rossijskaja Federativnaja Respublika / Rossija", "Ruble", "SUR"},
  {af, "rw", "Rwanda",         "La Rpublique Rwandaise / Republika y'u Rwanda", "Franc", "RWF"},
  {as, "sa", "Saudi Arabia",   "Al-Mamlaka al'Arabiya as-Sa'udiya", "Riyal", "SAR"},
  {as, "sb", "Solomon",        "(Solomon Islands)", "Dollar", "SBD"},
  {as, "sc", "Seychelles",     "The Republic of Seychelles", "Rupee", "SCR"},
  {af, "sd", "Sudan",          "Al Jumhuriyat al-Sudan", "Dinar", "SDD"},
  {eu, "se", "Sweden",         "Konungariket Sverige", "Krona", "SEK"},
  {as, "sg", "Singapore",      "Hsing-chia p'o Kung-ho Kuo / Republik Singapura / Republic of Singapore", "Dollar", "SGD"},
  {af, "sh", "St. Helena",     "Saint Helena (British)"},
  {eu, "si", "Slovenia",       "Republika Slovenija", "Tolar", "SIT"},
  {eu, "sj", "Svalbard",       "(Svalbard and Jan Mayen Islands)"},
  {eu, "sk", "Slovakia",       "Republika Slovensk", "Korouna", "SKK"},
  {af, "sl", "Sierra Leone",   "The Republic of Sierra Leone", "Leone", "SLL"},
  {eu, "sm", "San Marino",     "Repubblica di San Marino"},
  {af, "sn", "Senegal",        "La Rpublique du Sngal", "Franc", "SNF"},
  {af, "so", "Somalia",        "Jamhuuriyadda Dimugraadiga Soomaliya", "Shilling", "SOS"},
  {sa, "sr", "Suriname",       "Republiek Suriname", "Guilder", "SRG"},
  {sa, "st", "Sao Tome, Principe", "A Repblica Democrtica de So Tom e Prcipe", "Dobra", "STD"},
  {as, "su", "USSR",           "(Soviet Union)"},
  {sa, "sv", "El Salvador",    "La Repblica de El Salvador", "Colone", "SVC"},
  {as, "sy", "Syria",          "Al-Jumhuriy al'Arabia as-Suriya", "Pound", "SYP"},
  {af, "sz", "Swaziland",      "Umbuso Weswatina", "Emalangeni", "SZE"},
  {as, "tc", "Turks, Caicos",  "(Turks and Caicos Islands)", "Dollar", "USD"}, /* US Dollars */
  {af, "td", "Chad",           "La Rpublique du Tchad", "Franc", "TDF"},
  {af, "tf", "Southern",       "(French Southern Territories)"},
  {af, "tg", "Togo",           "La Rpublique Togolaise", "Franc", "TGF"},
  {as, "th", "Thailand",       "Prathet Thai", "Baht", "THB"},
  {as, "tj", "Tajikistan",     "Respublika i Tojikiston", "Ruble", "TJR"},
  {as, "tk", "Tokelau",        "Tokelau"},
  {as, "tm", "Turkmenistan",   "Tiurkmenostan", "Manat", "TMM"},
  {af, "tn", "Tunisia",        "Al-Jumhuriya at-Turnisiya", "Dinar", "TND"},
  {af, "to", "Tonga",          "Pule'anga Fakatu'i'o Tonga", "Pa'anga", "TOP"},
  {as, "tp", "East Timor",     ""},
  {as, "tr", "Turkey",         "Trkiye Cumhuriyeti", "Lira", "TRL"},
  {sa, "tt", "Trinidad",       "Republic of Trinidad and Tobago", "Dollar", "TTD"},
  {as, "tv", "Tuvalu",         "Tuvalu", "Dollar", "AUD"}, /* Australian Dollars */
  {as, "tw", "Taiwan",         "Chung-hua Min Kuo", "Dollar", "TWD"},
  {af, "tz", "Tanzania",       "Jamhuri ya Muungano wa Tanzania / The United Republic of Tanzania", "Shilling", "TZS"},
  {eu, "ua", "Ukraine",        "Ukraina", "Hryvna", "UAH"},
  {af, "ug", "Uganda",         "The Republic of Uganda", "Shilling", "YGS"},
  {eu, "uk", "United Kingdom", "The United Kingdom", "Pound", "UKP"},
  {na, "um", "Minor Outlying", "United States Minor Outlying Islands"},
  {na, "us", "United States",  "United States of America", "Dollar", "USD"},
  {sa, "uy", "Uruguay",        "La Repblica Oriental del Uruguay", "Uruguayo", "UYU"},
  {as, "uz", "Uzbekistan",     "Ozbekiston", "Som", "UZS"},
  {eu, "va", "Vatican",        "Stato delle Citt del Vaticano"},
  {sa, "vc", "Saint Vincent, Grenadines", "Saint Vincent and the Grenadines", "Dollar", "VCD"},
  {sa, "ve", "Venezuela",      "La Repblica de Venezuela", "Bolivar", "VEB"},
  {sa, "vg", "British Virgin", "British Virgin Islands", "Dollar", "USD"}, /* US Dollars */
  {sa, "vi", "US Virgin",      "U.S. Virgin Islands", "Dollar", "USD"}, /* US Dollars */
  {as, "vn", "Vietnam",        "Cng hoa x hi chu nghia Vit", "Dong", "VND"},
  {as, "vu", "Vanuatu",        "The Republic of Vanuatu / La Rpublique de Vanuatu", "Vatu", "VUV"},
  {as, "wf", "Wallis, Futuna", "Wallis and Futuna Islands"},
  {as, "ws", "Samoa",          "", "Tala", "WST"},
  {as, "ye", "Yemen",          "Al-Jamhiya al-Yamaniya", "Rial", "YER"},
  {0,  "yt", "Mayotte",        "(Territorial Collectivity of Mayotte)"},
  {eu, "yu", "Yugoslavia",     "Federativna Republika Jugoslavija", "Dinar", "YUD"},
  {af, "za", "South Africa",   "Republic of South Africa / Republiek van Suid-Afrika", "Rand", "ZAR"},
  {af, "zm", "Zambia",         "The Republic of Zambia", "Kwacha", "ZMK"},

  /* 1997-07-14
  ZAIRE (ZA) changed to CONGO, THE DEMOCRATIC REPUBLIC OF THE  (CD)
  change of name, alpha-2 and alpha-3, numeric remains 180 */

  {af, "zr", "Zaire",          "La Rpublique du Zare", "Zaire", "ZRZ"},
  {af, "zw", "Zimbabwe",       "The Republic of Zimbabwe", "Dollar", "ZWD"},

  {na, "edu", "Educational",   "U.S. Educational domain"},
  {na, "gov", "Government",    "U.S. Government"},
  {na, "mil", "Military",      "U.S. Military"},
  {na, "com", "Commercial",    ""},
  {na, "org", "Organization",  ""},
  {na, "net", "Net",           ""},
  {na, "int", "International", ""},
  {na, "nato","Nato",          ""},
  {na, "arpa","Arpa",          ""},

  {eu, ""/*none*/, "EU", "European Union", "Euro", "EUR"},
};

/* --- MarkLetters ------------------------------------------------ */

ulong MarkLetters(char *name)
{
  char c;
  ulong let = 0;

  while (c = *name++)
    let |= 1 << (c % ULONG_BIT);
  return let;
}

/* --- HammingDistance -------------------------------------------- */

ulong HammingDistance(ulong x, ulong y)
{
  ulong a = 0;

  for (x ^= y; x; a += (x & 1), x >>= 1);
  return a;
}

/* --- UnequalBits ------------------------------------------------ */

ulong UnequalBits(ulong x, ulong y)
{
  ulong a = 0;

  for (x ^= (x | y); x; a += (x & 1), x >>= 1);
  return a;
}

/* --- FindByCode ------------------------------------------------- */

/* Given the code find the country */

land *FindByCode(char *code)
{
  int i;

  for (i=0; i < sizeof(countries)/sizeof(countries[0]); i++) {
    if (StrEqual(countries[i].code, code))
      return &countries[i];
  }
  return NULL;
}

/* --- FindByCurrency --------------------------------------------- */

/* Given the currency find the country
 *
 * There might be several countries using the same currency (USD, AUD. NZD are
 * a few examples). To fullfill this match, we want the country that the
 * currency originate from and therefore we check that the first two letters
 * of the toplevel domain name is the same as the currency's.
 */

land *FindByCurrency(char *code)
{
  int i;

  for (i=0; i < sizeof(countries)/sizeof(countries[0]); i++) {
    if (countries[i].currency &&
        StrEqualMax(countries[i].currency, 2, countries[i].code) &&
        StrEqual(countries[i].currency, code))
      return &countries[i];
  }
  return NULL;
}

/* --- FindByCountry ---------------------------------------------- */

land *FindByCountry(char *country)
{
  int min = INT_MAX;
  int index = -1;
  int i, d;
  ulong sig, let;

  sig = HashSignatureU(country);
  let = MarkLetters(country);

  for (i=0; i < sizeof(countries)/sizeof(countries[0]); i++) {
    d = HammingDistance(countries[i].sig, sig) +
        UnequalBits(countries[i].let, let);
    if (min > d) {
      min = d;
      index = i;
    }
  }

  return ((index > -1) ? &countries[index] : NULL);
}

/* --- Country ---------------------------------------------------- */

/* If prepended by a dot (.)
 *   search for code
 * Else if nick on channel
 *   search for top-level domain
 * Else
 *   search for country name
 */

void Country(char *from, char *line)
{
  extern char *errfrom;
  char buffer[BIGBUFFER] = "";
  char *country, *pointer;
  itemguest *g;
  land *n;

  country = NextQuoteWord(line);
  if (country) {
    if ('.' == country[0]) {
      n = FindByCode(&country[1]);
      if (n) {
        if (n->fullname[0])
          StrFormatMax(buffer, sizeof(buffer), " (%s)", n->fullname);
        Sendf(from, "%s %s %s%s", country, GetText(msg_is), n->country, buffer);
      }
      else
        Sendf(from, GetText(msg_x_not_found), country);
    }
    else {
      g = FindNick(country);
      if (g) {
        pointer = StrIndexLast(g->ident->host, '.');
        if (pointer) {
          n = FindByCode(&pointer[1]);
          if (n) {
            if (n->fullname[0])
              StrFormatMax(buffer, sizeof(buffer), " (%s)", n->fullname);
            Sendf(from, GetText(msg_is_from), country, n->country, buffer);
          }
          else /* Catching IP numerical addresses */
            Sendf(from, GetText(msg_cannot_find_info), country);
        }
      }
      else {
        n = FindByCountry(country);
        if (n) {
          if (n->fullname[0])
            StrFormatMax(buffer, sizeof(buffer), " (%s)", n->fullname);
          if (StrEqual(n->country, country))
            Sendf(from, GetText(msg_has_country_code), country, n->code, buffer);
          else
            Sendf(from, GetText(msg_has_country_assuming),
                  country, n->code, n->country, buffer);
        }
        else
          Sendf(from, GetText(msg_is_unknown), country);
      }
    }
  }
  else
    CmdSyntax(errfrom, "COUNTRY");
}

/* --- CountryInit ------------------------------------------------ */

void CountryInit(void)
{
  int i;

  for (i=0; i < sizeof(countries)/sizeof(countries[0]); i++) {
    countries[i].sig = HashSignatureU(countries[i].country);
    countries[i].let = MarkLetters(countries[i].country);
  }
}
