/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/netstuff.h,v $
 * $Revision: 1.2 $
 * $Date: 2001/06/10 23:05:09 $
 * $Author: holsta $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef NETSTUFF_H
#define NETSTUFF_H

#include "dancer.h"
#include "user.h"
#include <netinet/in.h>

void NetInit(void);
void NetCleanup(void);
int OpenConnection(char *, char *);
int OpenServerConnection(char *, char *);
itemclient *OpenClientConnection(char *, char *, itemuser *, char *, int);
void CloseConnection(int);
bool Alive(int);
void EventLoop(void);
inline void WriteNick(char *, char *);
void WriteServer(char *, ...);
inline void WriteSocket(int, char *);
void WriteSocketf(int, char *, ...);
char *MakeIP(ulong);
void Outgoing(char *, char, char *);

#define OUT_LINK 1
#define OUT_CHAT 2
#define OUT_SEND 3

/* *NO* trailing slash on the dir names below! */

/* add this to the left of all names you're getting */
#define DCC_FILEPATH "/pub"

/* this is the directory for the local cached files */
#define DCC_FILECACHE "./tmp"

/* this is the primary ftp site to download from */
#define DCC_PRIMARY_FTP "lisa.sth.frontec.se"

#endif /* NETSTUFF_H */
