/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/news.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:45 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef NEWS_H
#define NEWS_H

#define NEWS_URGENT (1<<0)

typedef struct NewsStruct {
  struct Header h;
  long id;          /* unique ID */
  time_t time;      /* time of add */
  long level;       /* level required to get this */
  char *author;     /* who added this */
  long flags;       /* flags as defined below */
  long expire;      /* number of days this is allowed to live */
  char *match;      /* account match */
  char *news;       /* the actual news */
} itemnews;

void NewsSave(void);
itemnews *NewsAddItem(char *author,
                      long level,
                      long id,
                      time_t time,
                      long flags,
                      long expire,
                      char *match,
                      char *news);
void NewsInit(void);
void NewsCleanup(void);
long NewsID(void);
void NewsReport(itemident *);
void NewsList(char *, long);

#endif /* NEWS_H */
