/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/tell.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:49 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef TELL_H
#define TELL_H

#include "dancer.h"
#include "user.h"
#include "list.h"

typedef struct Tellstruct {
  struct Header h;
  int id;
  char *sender;    /* a!b@c.d */
  char *receiver;  /* b@c.d */
  char *rcvdomain; /* b@*.d */
  time_t when;
  char *message;
} itemtell;


void TellInit(void);
void TellCleanup(void);
void TellMe(char *, char *, bool);
void TellAdd(char *, char *, char *, char *);
void TellDel(char *, char *, char *);
void TellList(char *, char *);
void TellNotify(itemguest *);
void TellSave(void);

#endif /* TELL_H */
