

#include <windows.h>
#include <mapi.h>
#include <stdio.h>

#include "send_email.h"

int send_email(const char *sendname, 
               const char *recvname, 
               const char *ccname, 
               const char *subj,
               const char *body,
               const char *path)
{
    FLAGS flags;
    MapiMessage msg;
    ULONG send_res;
    MapiRecipDesc orig;
    MapiRecipDesc recips[20];
    MapiRecipDesc *recip = &recips[0], *cc = &recips[1];
    int num_recip = 1;
    MapiFileDesc attachment;
    MapiFileTagExt file_type;
    const char *filename;
 
    
    memset(&orig, 0, sizeof(orig));
    orig.ulRecipClass = MAPI_ORIG;
    orig.lpszName = (LPSTR)sendname;
    orig.lpszAddress = 0;
    orig.ulEIDSize = strlen(sendname);
    orig.lpEntryID = (LPSTR)sendname;

    memset(recip, 0, sizeof(recip));
    recip->ulRecipClass = MAPI_TO;
    recip->lpszName = (LPSTR)recvname;
    recip->lpszAddress = 0;
    recip->ulEIDSize = strlen(recvname);
    recip->lpEntryID = (LPSTR)recvname;

    if (ccname && strlen(ccname) > 0) {
        memset(cc, 0, sizeof(cc));
        cc->ulRecipClass = MAPI_CC;
        cc->lpszName = (LPSTR)ccname;
        cc->lpszAddress = 0;
        cc->ulEIDSize = strlen(ccname);
        cc->lpEntryID = (LPSTR)ccname;
        num_recip++;
    }


    memset(&msg, 0, sizeof(msg));
    msg.lpOriginator = &orig;
    msg.lpRecips = recip;
    msg.lpszMessageType = "text/plain";
    msg.lpszNoteText = body;
    msg.lpszSubject = (LPSTR)subj;
    msg.nRecipCount = num_recip;
    msg.flFlags = 0;

    if (path) {
        filename = strrchr(path, '/');
        if (filename == 0)
            filename = strrchr(path, '\\');
        if (filename == 0)
            filename = path;
        else
            filename++;
        memset(&attachment, 0, sizeof(attachment));
        attachment.nPosition = -1;
        attachment.lpszPathName = (LPTSTR)path;
        attachment.lpszFileName = (LPTSTR)filename;

        attachment.lpFileType = &file_type;
        
        memset(&file_type, 0, sizeof(file_type));
        file_type.lpTag = "text/plain";
        file_type.cbTag = sizeof(file_type.lpTag);

        msg.nFileCount = 1;
        msg.lpFiles = &attachment;
    }


    flags = 0;
    send_res = MAPISendMail(0, 0, &msg, flags, 0);

    if (send_res != SUCCESS_SUCCESS) {
        fprintf(stderr, "MAPISendMail returned %ld\n", send_res);
        return -1;
    }

    return 0;
}


