#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf fooOld tempA tempB
mkdir fooOld tempA tempB
cd fooOld
$DARCS init
echo record author me > _darcs/prefs/defaults
echo ALL all >> _darcs/prefs/defaults
#echo ALL verbose >> _darcs/prefs/defaults
echo ALL ignore-times >> _darcs/prefs/defaults
echo Old > foo
$DARCS add foo
$DARCS record -m Old
cd ..

cd tempA
$DARCS init
cp ../fooOld/_darcs/prefs/defaults _darcs/prefs
$DARCS pull ../fooOld
echo A > foo
$DARCS record -m A
cd ..

cd tempB
$DARCS init
cp ../fooOld/_darcs/prefs/defaults _darcs/prefs
$DARCS pull ../fooOld
echo B > foo
$DARCS record -m B
$DARCS pull ../tempA
echo A > foo
$DARCS record -m "ok A's fine!"
cd ..
cat tempB/foo

# At this point, tempB and tempA should agree--since the conflict was
# resolved in favor of tempA.
cmp tempB/foo tempA/foo

cd tempA
echo AA > foo
$DARCS record -m "AA -- upping the ante!"
cd ..

cd tempB
$DARCS pull ../tempA
cd ..

cd tempA
$DARCS pull ../tempB
cd ..

# At this point, tempB and tempA should agree since we have pulled both ways.
cmp tempB/foo tempA/foo

rm -rf fooOld tempA tempB

