%  Copyright (C) 2002-2004 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\begin{code}
module Query ( query ) where

import DarcsCommands ( DarcsCommand(..),
                       CommandControl(Command_data) )
import QueryManifest ( query_manifest )
import Repository ( amInRepository )

query_description :: String
query_description = "Query information which is stored by darcs."

query_help :: String
query_help =
 "Use the --help option with the subcommands to obtain help for\n"++
 "subcommands (for example, \"darcs query manifest --help\").\n"

query :: DarcsCommand
query = SuperCommand {command_name = "query",
                      command_help = query_help,
                      command_description = query_description,
                      command_prereq = amInRepository,
                      command_sub_commands = [Command_data query_manifest]
                     }
\end{code}

\input{QueryManifest.lhs}
