#!/usr/bin/env perl

# Tests for the doppleganger conflict bug.

# For Zooko, with love
# Also, for issue81.

use lib 'lib/perl';

use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use strict;
use warnings;

system 'rm -rf temp';
my $wd = `pwd`;
chomp $wd;
mkdir 'temp';
chdir 'temp';

sub mycleanup {
  chdir $wd;
  system 'rm -rf temp/*';
  chdir 'temp';
}

ok (dopplegangers_conflict('old-fashioned-inventory'),
    "default repo format views doppleganger as a conflict");
mycleanup;
ok (dopplegangers_conflict('hashed'),
    "hashed  repo format views doppleganger as a conflict");
mycleanup;
ok ((not dopplegangers_conflict('darcs-2')),
    "with darcs-2 format, doppleganger's don't conflict! ");
mycleanup;
ok (resolution_dopplegangers_conflict('old-fashioned-inventory'),
    "default repo format views resolution doppleganger as a conflict");
mycleanup;
ok (resolution_dopplegangers_conflict('hashed'),
    "hashed  repo format views resolution doppleganger as a conflict");
mycleanup;
ok (not (resolution_dopplegangers_conflict('darcs-2')),
    "with darcs-2 format, resolution doppleganger's don't conflict! ");


sub dopplegangers_conflict {
    my $arg_to_init = shift;
    system 'rm -rf tmp_dopple tmp_ganger';

    mkpath 'tmp_dopple';
    chdir  'tmp_dopple';
    darcs 'init --'.$arg_to_init;

    # Map args to formats
    my %fmts = (
        'old-fashioned-inventory' => 'darcs-1.0',
        'darcs-2'                 => 'darcs-2',
        'hashed'                  => 'hashed',
    );

    like((darcs 'show repo'), qr/$fmts{$arg_to_init}/,
         "reality check: $fmts{$arg_to_init} is repo format of tmp_doppel");

    touch 'a.txt';
    darcs "add a.txt";
    my $out = darcs "record -A base -am 'adding a.txt'";
    like($out, qr/finished/msxi, "$arg_to_init: recorded patch for adding file.");

    chdir '../';

    $out = darcs 'get tmp_dopple tmp_ganger';
    like($out, qr/inished getting/, 'get tmp_dopple tmp_ganger worked');
    #diag $out;

    #like((darcs 'show repo --repodir=tmp_ganger'), qr/$fmts{$arg_to_init}/,
    #     "reality check: $fmts{$arg_to_init} is repo format for tmp_ganger");

    for my $repo (qw(dopple ganger)) {
        ok((chdir  "tmp_$repo"), "chdir'ed tmp_$repo");
        `echo "text which appears in both places at once" > a.txt`;
        my $out = darcs "record -A $repo -am 'recording an identical change'";
        like($out, qr/finished/msxi, "$arg_to_init: recorded patch in $repo");
#        diag "in loop: $out";
        chdir '../';
    };

    # Now that the conflict has been set up, try pull one patch from the other.
    chdir 'tmp_ganger';

    my $pull_out = darcs 'pull -a ../tmp_dopple';
    my $has_a_conflict_p = ($pull_out =~ m/conflict/msxi);
#    diag "result: $pull_out";

    ####

#    diag "about to to return: $has_a_conflict_p";

    return $has_a_conflict_p;
}

sub resolution_dopplegangers_conflict {
    my $arg_to_init = shift;

    system 'rm -rf temp0 temp1 temp2';

    # Map args to formats
    my %fmts = (
        'old-fashioned-inventory' => 'darcs-1.0',
        'darcs-2'                 => 'darcs-2',
        'hashed'                  => 'hashed',
    );

    mkpath 'temp0';
    chdir  'temp0';
    darcs 'init --'.$arg_to_init;
    like((darcs 'show repo'), qr/$fmts{$arg_to_init}/,
         "reality check: $fmts{$arg_to_init} is repo format of temp0");
    #diag (darcs 'show repo');
    chdir  '..';

    # Create a conflict
    darcs 'get ../temp0 temp1';
    chdir 'temp1';
    #diag (darcs 'show repo');
    like((darcs 'show repo'), qr/$fmts{$arg_to_init}/,
         "reality check: $fmts{$arg_to_init} is repo format of temp1");
    `echo "temp1" > a.txt`;
    darcs "add a.txt";
    darcs "record  -A base -am 'adding a.txt'";
    chdir '..';
    darcs 'get ../temp0 temp2';
    chdir 'temp2';
    #diag (darcs 'show repo');
    `echo "temp2" > a.txt`;
    darcs "add a.txt";
    darcs "record  -A base -am 'adding a.txt'";
    chdir '..';

    # Resolve the conflict the same way on both sides
    for my $repo (qw(dopple ganger)) {
        darcs "get temp1 tmp_$repo";
        ok((chdir  "tmp_$repo"), "chdir'ed tmp_$repo");
        darcs "pull -a ../temp2";
        `echo "text which appears in both places at once" > a.txt`;
        my $out = darcs "record -A $repo -am 'recording an identical change'";
        like($out, qr/finished/msxi, "$arg_to_init: recorded patch in $repo");
        #diag "in loop: $out";
        chdir '../';
    };

    # Now that the conflict has been set up, try pull one patch from the other.
    chdir 'tmp_ganger';

    my $pull_out = darcs 'pull -a ../tmp_dopple';
    #diag (darcs 'changes -v');
    my $has_a_conflict_p = ($pull_out =~ m/conflict/msxi);
    #diag "result: $pull_out";
    chdir '..';
    

    ####

    #diag "about to to return: $has_a_conflict_p";

    return $has_a_conflict_p;
}


