#!/usr/bin/env perl

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;

init_tmp_repo();
touch 'foo';
darcs 'add foo';
`echo first > foo`;
darcs 'record -a -m "first edit" -A author1';
`echo second > foo`;
darcs 'record -a -m "second edit" -A author2';
darcs 'tag t1 -A moi';
`echo third > foo`;
darcs 'record -a -m "third edit" -A author3';
`echo fourth > foo`;
darcs 'record -a -m "fourth edit" -A author4';
`echo unrecorded > foo`;
like( darcs('show contents foo'), qr/fourth/, 'show contents sans version arguments' );
like( darcs('show contents foo -p third'), qr/third/, 'show contents -p' );
like( darcs('show contents foo --match="author1 first"'), qr/first/, 'show contents --match' );
like( darcs('show contents foo --tag t1'), qr/second/, 'show contents --tag' );
