#!/usr/bin/env bash

. ../tests/lib

set -ev
switch_to_latin9_locale
rm -rf temp1
rm -rf temp2
mkdir temp1
mkdir temp2
cd temp1

seventysevenaddy="<aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa@bbbbbbbbbb.cccccccccc.abrasoft.com>"

darcs init

echo "Have you seen the smrrebrd of Ren avsant?" > non_ascii_file
darcs add non_ascii_file
darcs record -am "non-ascii file add" -A test

cd ../temp2
darcs init
cd ../temp1

# long email adress: check that email adresses of <= 77 chars don't get split up
darcs send --from="Kjlt berstrm $seventysevenaddy" \
           --subject "Un patch pour le rpositoire" \
           --to="Un garon franais <garcon@francais.fr>" \
           --sendmail-command='tee mail_as_file %<' \
           -a ../temp2

cat mail_as_file
# The long mail address should be in there as a whole
grep $seventysevenaddy mail_as_file

# Check that there are no non-ASCII characters in the mail
ghc -e 'getContents >>= return . not . any (> Data.Char.chr 127)' < mail_as_file | grep '^True$'


cd ..
rm -rf temp1
rm -rf temp2

