/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _COLOR_MANAGER_H_
#define _COLOR_MANAGER_H_

#include <qglobal.h>

class QByteArray;

class ColorManager {
  private:
    ColorManager();
    ~ColorManager();
  public:
    const QByteArray& sRGBLinearProfile() const;
    void RGB16linearToSRGB16(quint16* , quint16*) const;
    static const ColorManager* instance();
  private:
    struct Private;
    Private* const d;
};

#endif
