/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef DARKROOM_H
#define DARKROOM_H


#include <kxmlguiwindow.h>

class QModelIndex;
class PostProcessor;

namespace KDcrawIface {
  class RawDecodingSettings;
}

namespace ThreadWeaver {
  class Weaver;
}

/**
 * This class serves as the main window for Darkroom.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Cyrille Berger <cberger@cberger.net>
 * @version 0.1
 */
class Darkroom : public KXmlGuiWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Darkroom();

    /**
     * Default Destructor
     */
    virtual ~Darkroom();
    void openUrl(const QString&);
    KDcrawIface::RawDecodingSettings rawDecodingSettings();
    PostProcessor postProcessor();
  private slots:
    void rawFileActivated ( const QModelIndex & index );
    void fileOpenDir();
    void fileOpen();
    void weaverStatusChanged();
    void applyCurrentSettings();
    void customFileViewContextMenuRequested( const QPoint& pos );
  protected:
    virtual void closeEvent(QCloseEvent *event);
  private:
    void openDir( const QString& _directory );
    void openFile( const QString& _file );
    void setupActions();
    void setupDockers();
    void observeWeaver( ThreadWeaver::Weaver* weaver );
    bool idling();
  private:
    struct Private;
    Private* const d;
};

#endif // _DARKROOM_H_
