/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _LIST_RAW_FILE_MODEL_H_
#define _LIST_RAW_FILE_MODEL_H_

#include <QAbstractListModel>
#include <QList>

class RawImageInfo;

class ListRawFileModel : public QAbstractListModel {
  Q_OBJECT
  public:
    ListRawFileModel( const QList<RawImageInfo*>& _infos  );
    virtual ~ListRawFileModel();
    int rowCount ( const QModelIndex & parent = QModelIndex() ) const;    
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
  private slots:
    void dataUpdated(int _index);
  private:
    struct Private;
    Private* const d;
};

#endif
