/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _RAW_IMAGE_INFO_H_
#define _RAW_IMAGE_INFO_H_

#include <QObject>
#include <QVariant>

class QFileInfo;
class QPixmap;

class RawImageInfo : public QObject {
  Q_OBJECT
  public:
    enum Status {
      IDLING,
      LOADING,
      PREVIEWING,
      DECODING,
      POSTPROCESSING,
      SAVING,
      DONE,
      ERROR
    };
  public:
    RawImageInfo(const QFileInfo& fileInfo );
    ~RawImageInfo();
    const QFileInfo& fileInfo() const;
    const QPixmap& preview() const;
    const QPixmap& icon() const;
    void setPreview(const QImage& );
    void setStatus( Status _newStatus );
  signals:
    void previewChanged( );
    void iconChanged( );
  private:
    struct Private;
    Private* const d;
};

Q_DECLARE_METATYPE ( RawImageInfo* );
#endif
