/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _RAW_IMAGE_INFO_H_
#define _RAW_IMAGE_INFO_H_

#include <QObject>
#include <QSharedData>
#include <QVariant>

class QFileInfo;
class QPixmap;

class PreviewInfo;
class ProcessingOptions;

class RawImageInfo : public QObject, public QSharedData {
  Q_OBJECT
  public:
    enum Status {
      IDLING,
      LOADING,
      PREVIEWING,
      DECODING,
      POSTPROCESSING,
      SAVING,
      DONE,
      ERROR
    };
  public:
    RawImageInfo(const QFileInfo& fileInfo );
    ~RawImageInfo();
    const QFileInfo& fileInfo() const;
    const QPixmap& thumbnail() const;
    const QPixmap& icon() const;
    void setThumbnail(const QImage& );
    void setStatus( Status _newStatus );
    const PreviewInfo* previewInfo() const;
    const ProcessingOptions& processingOptions() const;
    void setProcessingOptions( const ProcessingOptions& _processingOptions );
  public slots:
    void setPreviewInfo( const PreviewInfo* );
  signals:
    void previewChanged( );
    void iconChanged( );
  private:
    struct Private;
    Private* const d;
};

typedef QExplicitlySharedDataPointer<RawImageInfo> RawImageInfoSP;

Q_DECLARE_METATYPE ( RawImageInfoSP )
#endif
