/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#include "ListRawFileModel.h"

#include <QFileInfo>
#include <QPixmap>
#include <QSignalMapper>

#include <kdebug.h>

struct ListRawFileModel::Private {
    QList<RawImageInfoSP> infos;
    QMap<QString, QPixmap> pixmapCache;  
    QSignalMapper* dataMapper;
};


ListRawFileModel::ListRawFileModel( const QList<RawImageInfoSP>& _infos ) : d(new Private) 
{
  d->infos = _infos;
  d->dataMapper = new QSignalMapper( this );
  for(int i = 0; i < _infos.size(); ++i)
  {
    connect(_infos[i].data(), SIGNAL(iconChanged()), d->dataMapper, SLOT(map()));
    d->dataMapper->setMapping( _infos[i].data(), i );
  }
  connect(d->dataMapper, SIGNAL(mapped(int)), SLOT(dataUpdated(int)));
}

ListRawFileModel::~ListRawFileModel()
{
  delete d;
}

int ListRawFileModel::rowCount ( const QModelIndex & parent) const
{
  Q_UNUSED(parent);
  return d->infos.size();
}

QVariant ListRawFileModel::data ( const QModelIndex & index, int role ) const
{
  switch( role )
  {
    case Qt::DisplayRole:
    {
      return d->infos[ index.row() ]->fileInfo().fileName();
    }
    case Qt::DecorationRole:
    {
      return d->infos[ index.row() ]->icon();
    }
    case 100:
    {
      return qVariantFromValue(d->infos[ index.row() ]);
    }
  }
  return QVariant();
}

void ListRawFileModel::dataUpdated(int _index)
{
  kDebug() << "dataUpdated";
  QModelIndex mi = createIndex(_index, 0);
  emit( dataChanged(mi, mi));
}

#include "ListRawFileModel.moc"
