
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __GRAPH_H
#define __GRAPH_H

#include "bignum.h"
#include <stdio.h>
#include <pthread.h>

/* don't touch! */
#define GRAPH_SECS 60
#define GRAPH_MINS 60
#define GRAPH_HRS 24
#define GRAPH_DAYS 31

extern pthread_mutex_t graph_mutex;

/* circular buffers */
extern int64 graph_sec_in[GRAPH_SECS], graph_sec_out[GRAPH_SECS];
extern int64 graph_min_in[GRAPH_MINS], graph_min_out[GRAPH_MINS];
extern int64 graph_hr_in[GRAPH_HRS], graph_hr_out[GRAPH_HRS];
extern int64 graph_day_in[GRAPH_DAYS], graph_day_out[GRAPH_DAYS];

extern time_t graph_time;
extern byte g_secs, g_mins, g_hrs, g_days;

void init_graph(void);
inline void graph_add_in(const dword amount);
inline void graph_add_out(const dword amount);
void graph_rotate(const time_t now);
void graph_calibrate_to_clock(void);

void graph_save(FILE *fp);
int graph_load(FILE *fp);

#endif

