/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class NodeTest
extends Expression {
    public static final String WILD = "*";
    public static final String SUPPORTS_PRE_STRIPPING = "http://xml.apache.org/xpath/features/whitespace-pre-stripping";
    protected int m_whatToShow;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    protected String m_name;
    XNumber m_score;
    public static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    public static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    public static final XNumber SCORE_QNAME = new XNumber(0.0);
    public static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public NodeTest() {
    }

    public NodeTest(int n) {
        this.initNodeTest(n);
    }

    public NodeTest(int n, String string, String string2) {
        this.initNodeTest(n, string, string2);
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public static void debugWhatToShow(int n) {
        Vector<String> vector = new Vector<String>();
        if ((n & 2) != 0) {
            vector.addElement("SHOW_ATTRIBUTE");
        }
        if ((n & 0x1000) != 0) {
            vector.addElement("SHOW_NAMESPACE");
        }
        if ((n & 8) != 0) {
            vector.addElement("SHOW_CDATA_SECTION");
        }
        if ((n & 0x80) != 0) {
            vector.addElement("SHOW_COMMENT");
        }
        if ((n & 0x100) != 0) {
            vector.addElement("SHOW_DOCUMENT");
        }
        if ((n & 0x400) != 0) {
            vector.addElement("SHOW_DOCUMENT_FRAGMENT");
        }
        if ((n & 0x200) != 0) {
            vector.addElement("SHOW_DOCUMENT_TYPE");
        }
        if ((n & 1) != 0) {
            vector.addElement("SHOW_ELEMENT");
        }
        if ((n & 0x20) != 0) {
            vector.addElement("SHOW_ENTITY");
        }
        if ((n & 0x10) != 0) {
            vector.addElement("SHOW_ENTITY_REFERENCE");
        }
        if ((n & 0x800) != 0) {
            vector.addElement("SHOW_NOTATION");
        }
        if ((n & 0x40) != 0) {
            vector.addElement("SHOW_PROCESSING_INSTRUCTION");
        }
        if ((n & 4) != 0) {
            vector.addElement("SHOW_TEXT");
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 > 0) {
                System.out.print(" | ");
            }
            System.out.print(vector.elementAt(n3));
            ++n3;
        }
        if (n2 == 0) {
            System.out.print("empty whatToShow: " + n);
        }
        System.out.println();
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        short s = dTM.getNodeType(n);
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int n2 = this.m_whatToShow & 1 << s - 1;
        switch (n2) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dTM.getNodeName(n), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String string = dTM.getNodeValue(n);
                return NodeTest.subPartMatch(string, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dTM.getNamespaceURI(n), this.m_namespace) && NodeTest.subPartMatch(dTM.getLocalName(n), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int n3 = this.m_whatToShow & 1 << (n2 >> ExpandedNameTable.ROTAMOUNT_TYPE) - 1;
        switch (n3) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dTM.getNodeName(n), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String string = dTM.getNodeValue(n);
                return NodeTest.subPartMatch(string, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dTM.getNamespaceURI(n), this.m_namespace) && NodeTest.subPartMatch(dTM.getLocalName(n), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    public void fixupVariables(Vector vector, int n) {
    }

    public double getDefaultScore() {
        return this.m_score.num();
    }

    public String getLocalName() {
        return this.m_name == null ? "" : this.m_name;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public static int getNodeTypeTest(int n) {
        if ((n & 1) != 0) {
            return 1;
        }
        if ((n & 2) != 0) {
            return 2;
        }
        if ((n & 4) != 0) {
            return 3;
        }
        if ((n & 0x100) != 0) {
            return 9;
        }
        if ((n & 0x400) != 0) {
            return 11;
        }
        if ((n & 0x1000) != 0) {
            return 13;
        }
        if ((n & 0x80) != 0) {
            return 8;
        }
        if ((n & 0x40) != 0) {
            return 7;
        }
        if ((n & 0x200) != 0) {
            return 10;
        }
        if ((n & 0x20) != 0) {
            return 6;
        }
        if ((n & 0x10) != 0) {
            return 5;
        }
        if ((n & 0x800) != 0) {
            return 12;
        }
        if ((n & 8) != 0) {
            return 4;
        }
        return 0;
    }

    public XNumber getStaticScore() {
        return this.m_score;
    }

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public void initNodeTest(int n) {
        this.m_whatToShow = n;
        this.calcScore();
    }

    public void initNodeTest(int n, String string, String string2) {
        this.m_whatToShow = n;
        this.m_namespace = string;
        this.m_name = string2;
        this.calcScore();
    }

    public void setLocalName(String string) {
        this.m_name = string;
    }

    public void setNamespace(String string) {
        this.m_namespace = string;
    }

    public void setStaticScore(XNumber xNumber) {
        this.m_score = xNumber;
    }

    public void setWhatToShow(int n) {
        this.m_whatToShow = n;
    }

    private static final boolean subPartMatch(String string, String string2) {
        return string == string2 || string != null && (string2 == WILD || string.equals(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean subPartMatchNS(String string, String string2) {
        if (string == string2) return true;
        if (string == null) return false;
        if (string.length() > 0) {
            if (string2 == WILD) return true;
            if (string.equals(string2)) return true;
            return false;
        }
        if (string2 == null) return true;
        return false;
    }
}

