<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:preserve-space elements="xsl:text"/>
  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:call-template name="Notes">
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="Summary"/>
  </xsl:template>

  <xsl:template name="Notes">
    <xsl:param name="IconDir">../../Icons</xsl:param>
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Notes for <xsl:value-of select="NoteCollection/Site/@Name"/> -- <xsl:value-of select="NoteCollection/Site/@BuildName"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
<xsl:if test="count(NoteCollection/Site/BuildNameNotes/Note)">
<h3><xsl:attribute name="style">background: <xsl:value-of select="$LightBlue"/></xsl:attribute>Notes for <xsl:value-of select="NoteCollection/Site/@BuildName"/></h3>
<xsl:for-each select="NoteCollection/Site/BuildNameNotes/Note">
   <p>
   <img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Alert.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute><xsl:attribute name="ALIGN">texttop</xsl:attribute></img><xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
   <b><xsl:value-of select="DateTime"/></b><br/>
   <xsl:value-of select="Text"/>
   </p>	
</xsl:for-each>
</xsl:if>
<xsl:if test="count(NoteCollection/Site/Notes/Note)">
<h3><xsl:attribute name="style">background: <xsl:value-of select="$LightBlue"/></xsl:attribute>Notes for <xsl:value-of select="NoteCollection/Site/@BuildName"/> -- <xsl:value-of select="NoteCollection/Site/@BuildStamp"/></h3>
<xsl:for-each select="NoteCollection/Site/Notes/Note">
   <p>
   <img><xsl:attribute name="SRC"><xsl:value-of select="$IconDir"/>/Alert.gif</xsl:attribute><xsl:attribute name="ALT">Notes</xsl:attribute><xsl:attribute name="border">0</xsl:attribute><xsl:attribute name="ALIGN">texttop</xsl:attribute></img><xsl:text disable-output-escaping="yes"> &amp;nbsp;&amp;nbsp;</xsl:text>
   <b><xsl:value-of select="DateTime"/></b><br/>
   <xsl:value-of select="Text"/>
   </p>	
</xsl:for-each>
</xsl:if>
<xsl:call-template name="DashboardFooter">
   <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
</xsl:call-template>
</xsl:template>

<xsl:template name="Summary">
  <redirect:write select="concat(string('{$TestDocDir}'), '/NotesSummary.xml' )">
    <Notes>
      <SiteName><xsl:value-of select="NoteCollection/Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="NoteCollection/Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="NoteCollection/Site/@BuildStamp"/></BuildStamp>
      <NotesCount><xsl:value-of select="count(NoteCollection/Site/BuildNameNotes/Note) + count(NoteCollection/Site/Notes/Note)"/></NotesCount>
    </Notes>
  </redirect:write>
</xsl:template>


</xsl:stylesheet>
