/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, WithParam[] withParamArray, WithParam[] withParamArray2, boolean bl, Expression expression, NamespaceResolver namespaceResolver) {
        this.template = template;
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
        this.useTailRecursion = bl;
        this.calledTemplateExpression = expression;
        this.nsContext = namespaceResolver;
    }

    public String getInstructionName() {
        return "call-template";
    }

    public void process(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        controller.getBindery().openStackFrame(Instruction.assembleParams(xPathContext, this.actualParams), Instruction.assembleTunnelParams(xPathContext, this.tunnelParams));
        TailCall tailCall = controller.isTracing() ? this.getTargetTemplate(xPathContext).traceExpand(controller) : this.getTargetTemplate(xPathContext).expand(controller);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(controller);
        }
        controller.getBindery().closeStackFrame();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (!this.useTailRecursion) {
            this.process(xPathContext);
            return null;
        }
        Template template = this.getTargetTemplate(xPathContext);
        ParameterSet parameterSet = Instruction.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = Instruction.assembleTunnelParams(xPathContext, this.tunnelParams);
        if (parameterSet == null) {
            parameterSet = new ParameterSet();
        }
        return new CallTemplatePackage(template, parameterSet, parameterSet2, xPathContext.getController().saveContext());
    }

    private Template getTargetTemplate(XPathContext xPathContext) throws TransformerException {
        if (this.calledTemplateExpression != null) {
            String string;
            String string2;
            Object object;
            Controller controller = xPathContext.getController();
            String string3 = this.calledTemplateExpression.evaluateAsString(xPathContext);
            try {
                object = Name.getQNameParts(string3);
                string2 = object[0];
                string = object[1];
            }
            catch (QNameException qNameException) {
                throw this.dynamicError("Invalid template name. " + qNameException.getMessage(), controller);
            }
            object = this.nsContext.getURIForPrefix(string2, false);
            if (object == null) {
                throw this.dynamicError("Namespace prefix " + string2 + " has not been declared", controller);
            }
            int n = controller.getNamePool().getFingerprint((String)object, string);
            HashMap hashMap = controller.getExecutable().getNamedTemplateTable();
            Template template = (Template)hashMap.get(new Integer(n));
            if (template == null) {
                throw this.dynamicError("Template " + string3 + " has not been defined", controller);
            }
            return template;
        }
        return this.template;
    }

    private static class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private Object[] executionContext;

        public CallTemplatePackage(Template template, ParameterSet parameterSet, ParameterSet parameterSet2, Object[] objectArray) {
            this.target = template;
            this.params = parameterSet;
            this.tunnelParams = parameterSet2;
            this.executionContext = objectArray;
        }

        public TailCall processLeavingTail(Controller controller) throws TransformerException {
            Object[] objectArray = controller.saveContext();
            controller.restoreContext(this.executionContext);
            Bindery bindery = controller.getBindery();
            bindery.openStackFrame(this.params, this.tunnelParams);
            TailCall tailCall = controller.isTracing() ? this.target.traceExpand(controller) : this.target.expand(controller);
            bindery.closeStackFrame();
            controller.restoreContext(objectArray);
            return tailCall;
        }
    }
}

