/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.xpath.XPathException;

public abstract class ExprInstruction
extends Instruction
implements Expression {
    public Expression simplify() throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof Expression) {
                    Expression expression = ((Expression)((Object)this.children[n])).simplify();
                    if (expression instanceof Instr) {
                        this.children[n] = (Instr)((Object)expression);
                    } else {
                        SequenceInstruction sequenceInstruction = new SequenceInstruction(expression, null);
                        this.children[n] = sequenceInstruction;
                    }
                }
                ++n;
            }
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof Expression) {
                    Expression expression = ((Expression)((Object)this.children[n])).analyze(staticContext);
                    if (expression instanceof Instr) {
                        this.children[n] = (Instr)((Object)expression);
                    } else {
                        SequenceInstruction sequenceInstruction = new SequenceInstruction(expression, null);
                        this.children[n] = sequenceInstruction;
                    }
                }
                ++n;
            }
        }
        return this;
    }

    public int getDependencies() {
        int n = 0;
        Expression[] expressionArray = this.getSubExpressions();
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n |= expressionArray[n2].getDependencies();
            ++n2;
        }
        return n;
    }

    public int getSpecialProperties() {
        return 0x400000;
    }

    protected abstract void promoteInst(PromotionOffer var1) throws XPathException;

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.promoteInst(promotionOffer);
        return this;
    }

    protected abstract void getXPathExpressions(List var1);

    public Expression[] getSubExpressions() {
        ArrayList<Instr> arrayList = new ArrayList<Instr>();
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof Expression)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be Expressions");
                }
                arrayList.add(this.children[n]);
                ++n;
            }
        }
        this.getXPathExpressions(arrayList);
        Expression[] expressionArray = new Expression[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            expressionArray[n] = (Expression)arrayList.get(n);
            ++n;
        }
        return expressionArray;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public final String evaluateAsString(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        return SingletonIterator.makeIterator(item);
    }
}

