<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:preserve-space elements="xsl:text"/>
  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:call-template name="Summary"/>
    <xsl:apply-templates select="Site"/>
  </xsl:template>

  <xsl:template match="Site">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Configure Output <xsl:value-of select="@Name"/> -- <xsl:value-of select="@BuildName"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
     <p><b><xsl:text>Site:</xsl:text></b><xsl:value-of select="@Name"/></p><p>
<b><xsl:text>Build Name:</xsl:text></b><xsl:value-of select="@BuildName"/></p>
     <xsl:apply-templates select="Configure"/>
      <xsl:call-template name="DashboardFooter">
    <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      </xsl:call-template>
  </xsl:template>


  <xsl:template match="Configure">
    <p><b>Configure Command:</b><tt><xsl:value-of select="ConfigureCommand"/></tt></p>
    <p><b>Configure Return Value:</b><xsl:value-of select="ConfigureStatus"/> </p>
    <p><b>Configure Output:</b></p>
    <pre><xsl:value-of select="Log"/></pre>
  </xsl:template>


  <xsl:template name="Summary">
    <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/ConfigureSummary.xml' )" />
    <xsl:result-document href="{$uri}" >
      <Configure>
        <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
        <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
        <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
        <StartDateTime><xsl:value-of select="Site/Configure/StartDateTime"/></StartDateTime>
        <xsl:if test="count(Site/Configure/ConfigureStatus)">
          <ConfigureStatus><xsl:value-of select="Site/Configure/ConfigureStatus"/></ConfigureStatus>
        </xsl:if>
        <EndDateTime><xsl:value-of select="Site/Build/EndDateTime"/></EndDateTime>
      </Configure>
    </xsl:result-document>
  </xsl:template>
</xsl:stylesheet>
