/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2000 Trolltech AS.  All rights reserved.                *
 *   info@trolltech.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQLFORMWIZARDIMPL_H
#define SQLFORMWIZARDIMPL_H

#include "sqlformwizard.h"
#include <qvaluelist.h>

class Project;
class DataTable;
class DataField;

class SqlFormWizard : public SqlFormWizardBase
{
    Q_OBJECT

public:
    SqlFormWizard( Project* project, DataTable *table, DataTable* parentTable = 0, bool configure = false );
    ~SqlFormWizard();

    void accept();

protected slots:

    void doConnect();
    void newConnection();
    void deleteConnection();
    void connectionNameChanged( const QString &s );
    void currentConnectionChanged( const QString & );

    void parentKeyChanged();
    void childTableActivated( const QString &s );
    void childKeyActivated( const QString &s );
    void childRelationActivated( const QString &s );

    void tableSelected( const QString & name );
    void tableLabelChanged( const QString &label );
    void tableIconChanged();

    void fieldUp();
    void fieldDown();
    void sortDataFields();
    void removeField();
    void addField();
    void currentFieldChanged( QListBoxItem* );
    void fieldLabelChanged( const QString &label );
    void foreignToggled( bool toggle );
    void targetTableActivated();
    void targetKeyActivated();
    void targetFieldActivated();
    void hiddenToggled( bool toggle );
    void resizableToggled( bool toggle );
    void sortableToggled( bool toggle );

    void addSortField();
    void reSortSortField();
    void removeSortField();
    void sortFieldUp();
    void sortFieldDown();

    void nextPageClicked();

private:
    void enableAllConnectionPage( bool b );
    void enableAllRelationPage( bool b );
    void enableAllTablePage( bool b );
    void enableAllFieldPage( bool b );
    void enableAllSortPage( bool b );

private:
    Project *m_project;
    DataTable *m_list;
    DataTable *m_parentTable;
    bool m_configure;
    enum Mode {
        None,
        View,
        Browser,
        Table
    };
    Mode mode;

private:
    void setupFirstPage();
    void setupConnectionPage();
    void setupRelationPage();
    void setupTablePage();
    void setupFieldPage();
    void setupSortPage();

    DataField *findField( QListBoxItem *i );
};

#endif // SQLFORMWIZARDIMPL_H
