/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2000 Trolltech AS.  All rights reserved.                *
 *   info@trolltech.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASECONNECTION_H
#define DATABASECONNECTION_H

#include <qmap.h>
#include <qstring.h>
#include <qvariant.h>
#include <qptrlist.h>
#include <qptrdict.h>
#include <qfeatures.h>
#include <qstringlist.h>
#include <qobjectlist.h>

class QObjectList;
class QSqlDatabase;

class DatabaseConnection
{
public:
    DatabaseConnection() :
            conn( 0 ), loaded( false )
    {}
    virtual ~DatabaseConnection();

    bool refreshCatalog();
    bool open( bool suppressDialog = true );
    bool isOpen();
    void close();
    QVariant::Type getFieldType( const QString& t, const QString& f );
    int getFieldIsRequired( const QString& t, const QString& f );

    bool isLoaded() const
    {
        return loaded;
    }
    void setName( const QString& n )
    {
        nm = n;
    }
    QString name() const
    {
        return nm;
    }
    void setDriver( const QString& d )
    {
        drv = d;
    }
    QString driver() const
    {
        return drv;
    }
    void setDatabase( const QString& db )
    {
        dbName = db;
    }
    QString database() const
    {
        return dbName;
    }
    void setUsername( const QString& u )
    {
        uname = u;
    }
    QString username() const
    {
        return uname;
    }
    void setPassword( const QString& p )
    {
        pword = p;
    }
    QString password() const
    {
        return pword;
    }
    void setHostname( const QString& h )
    {
        hname = h;
    }
    QString hostname() const
    {
        return hname;
    }
    void setPort( int p )
    {
        prt = p;
    }
    int port() const
    {
        return prt;
    }
    QString lastError() const
    {
        return dbErr;
    }
    void addTable( const QString& t )
    {
        tbls.append( t );
    }
    void setFields( const QString& t, const QStringList& f )
    {
        flds[ t ] = f;
    }
    QStringList tables() const
    {
        return tbls;
    }
    QStringList fields( const QString& t )
    {
        return flds[ t ];
    }
    QMap<QString, QStringList> fields()
    {
        return flds;
    }
    QSqlDatabase* connection() const
    {
        return conn;
    }
    void remove
        ();

private:
    QString nm;
    QString drv, dbName, uname, pword, hname;
    QString dbErr;
    int prt;
    QStringList tbls;
    QMap<QString, QStringList> flds;

    QSqlDatabase *conn;

    bool loaded;
};

#endif
