/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef DATATABLEEDIT_H
#define DATATABLEEDIT_H

#include <qscrollview.h>
#include <qdatabrowser.h>

class FormLayout;
class DataEditorBase;
class QPushButton;
class QColor;
class QFrame;
class QSqlPropertyMap;

class ScrollForm : public QScrollView
{
    Q_OBJECT
public:
    ScrollForm( QWidget *parent = 0, const char *name = 0 );
    virtual ~ScrollForm();
    virtual void drawFrame( QPainter* p );
    QColor getFrameColor() const;
    void setFrameColor( const QColor &color );

private:
    QColor m_frameColor;
};

class DataTableEdit : public QDataBrowser
{
    Q_OBJECT
public:
    DataTableEdit( QWidget *parent = 0, const char *name = 0 );

    virtual ~DataTableEdit();

    void addEditorBase( DataEditorBase *editor, bool isVirtual = false );
    void removeEditors();
    void installPropertyMap( QSqlPropertyMap *map );

    FormLayout* getFormLayout() const;
    ScrollForm* getScrollView() const;
    QFrame* getFormBox() const;
    QVariant currentValue( const QString &field );
    void setCurrentRow( int row );
    virtual bool seek( int i, bool relative = false );

public slots:
    virtual void first();
    virtual void last();
    virtual void next();
    virtual void prev();
    virtual void update();

    virtual bool insertRecord(); //new
    virtual bool deleteRecord(); //new

    virtual void refresh();
    virtual void readFields();
    void calculateFields();
    void toggleColorBox();
    void constrainEditor( DataEditorBase *editor, const QString &field );

signals:
    void insertAborted();
    void colorBoxChanged( const QColor &color );
    void selectedFirst( bool updateCursor = false );
    void selectedPrev( bool updateCursor = false );
    void selectedNext( bool updateCursor = false );
    void selectedLast( bool updateCursor = false );
    void selectedRow( int row, bool updateCursor = false );

protected:
    virtual QSql::Confirm confirmEdit( QSql::Op m );
    virtual void showEvent( QShowEvent *ev );
    bool currentEdited();
    void handleError( const QSqlError & error );

private:
    void changeColorBox( QColor color );

private:
    FormLayout *m_formLayout;
    ScrollForm *m_scroll;
    QFrame *m_formBox;
    QSqlPropertyMap *m_map;
    QPushButton *m_commit;
    bool m_refreshing;
    bool m_inserting;
    int m_currentRow;
};

#endif
