/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef RELATIONEDITORDIALOGIMPL_H
#define RELATIONEDITORDIALOGIMPL_H

#include <relationeditordialog.h>

class DataField;
class DataTable;

class RelationEditorDialog : public RelationEditorDialogBase
{
    Q_OBJECT
public:
    RelationEditorDialog( DataField *dataField, DataTable *parentTable,
                          bool configure, QWidget *parent = 0,
                          const char *name = 0 );

    virtual ~RelationEditorDialog();

    void accept();

protected slots:
    void fieldUp();
    void fieldDown();

    void currentFieldChanged( QListBoxItem* );
    void hiddenToggled( bool toggle );
    void foreignToggled( bool toggle );
    void reportToggled( bool toggle );
    void targetTableActivated();
    void targetKeyActivated();
    void targetFieldActivated();
    void targetConstraintActivated();

    void newField();
    void deleteField();

private:
    void setup();
    DataField *findField( QListBoxItem *i );

private:
    DataField *m_dataField;
    DataTable *m_parentTable;
    bool m_configure;
};

#endif
