/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System;
using System.Diagnostics;
using System.Reflection;
using Mono.Cecil;

namespace Db4oAdmin
{
	public class InstrumentationContext
	{
		private AssemblyDefinition _assembly;
		private Configuration _configuration;

		public InstrumentationContext(Configuration configuration)
		{
			_assembly = AssemblyFactory.GetAssembly(configuration.AssemblyLocation);
			_configuration = configuration;
		}
		
		public Configuration Configuration
		{
			get { return _configuration; }
		}
		
		public TraceSwitch TraceSwitch
		{
			get { return _configuration.TraceSwitch;  }
		}
		
		public AssemblyDefinition Assembly
		{
			get { return _assembly;  }
		}
		
		public string AssemblyLocation
		{
			get { return _assembly.MainModule.Image.FileInformation.FullName;  }
		}
		
		public TypeReference Import(Type type)
		{
			return _assembly.MainModule.Import(type);
		}

		public MethodReference Import(MethodBase method)
		{
			return _assembly.MainModule.Import(method);
		}
		
		public void SaveAssembly()
		{
			AssemblyFactory.SaveAssembly(_assembly, AssemblyLocation);
		}
		
		public void TraceWarning(string message, params object[] args)
		{
			if (TraceSwitch.TraceWarning)
			{
				Trace.WriteLine(string.Format(message, args));
			}
		}

		public void TraceInfo(string message, params object[] args)
		{
			if (TraceSwitch.TraceInfo)
			{
				Trace.WriteLine(string.Format(message, args));
			}
		}

		public void TraceVerbose(string format, params object[] args)
		{
			if (TraceSwitch.TraceVerbose)
			{
				Trace.WriteLine(string.Format(format, args));
			}
		}
	}
}