/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Extensions.Fixtures
{
	public abstract class AbstractDb4oFixture : Db4oUnit.Extensions.IDb4oFixture
	{
		private readonly Db4oUnit.Extensions.Fixtures.IConfigurationSource _configSource;

		private Db4objects.Db4o.Config.IConfiguration _config;

		protected AbstractDb4oFixture(Db4oUnit.Extensions.Fixtures.IConfigurationSource configSource
			)
		{
			_configSource = configSource;
		}

		public virtual void Reopen()
		{
			Close();
			Open();
		}

		public virtual Db4objects.Db4o.Config.IConfiguration Config()
		{
			if (_config == null)
			{
				_config = _configSource.Config();
			}
			return _config;
		}

		public virtual void Clean()
		{
			DoClean();
			ResetConfig();
		}

		public virtual bool Accept(System.Type clazz)
		{
			return true;
		}

		protected abstract void DoClean();

		protected virtual void ResetConfig()
		{
			_config = null;
		}

		protected virtual void Defragment(string fileName)
		{
			string targetFile = fileName + ".defrag.backup";
			Db4objects.Db4o.Defragment.DefragmentConfig defragConfig = new Db4objects.Db4o.Defragment.DefragmentConfig
				(fileName, targetFile);
			defragConfig.ForceBackupDelete(true);
			defragConfig.Db4oConfig(Config());
			Db4objects.Db4o.Defragment.Defragment.Defrag(defragConfig);
		}

		public abstract void Close();

		public abstract Db4objects.Db4o.Ext.IExtObjectContainer Db();

		public abstract void Defragment();

		public abstract Db4objects.Db4o.Internal.LocalObjectContainer FileSession();

		public abstract string GetLabel();

		public abstract void Open();
	}
}
