/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit
{
	public class TestFailureCollection : Db4oUnit.Printable
	{
		internal System.Collections.ArrayList _failures = new System.Collections.ArrayList
			();

		public virtual System.Collections.IEnumerator Iterator()
		{
			return _failures.GetEnumerator();
		}

		public virtual int Size()
		{
			return _failures.Count;
		}

		public virtual void Add(Db4oUnit.TestFailure failure)
		{
			_failures.Add(failure);
		}

		public override void Print(System.IO.TextWriter writer)
		{
			PrintSummary(writer);
			PrintDetails(writer);
		}

		private void PrintSummary(System.IO.TextWriter writer)
		{
			int index = 1;
			System.Collections.IEnumerator e = Iterator();
			while (e.MoveNext())
			{
				writer.Write(index.ToString());
				writer.Write(") ");
				writer.Write(((Db4oUnit.TestFailure)e.Current).GetTest().GetLabel());
				writer.Write("\n");
				++index;
			}
		}

		private void PrintDetails(System.IO.TextWriter writer)
		{
			int index = 1;
			System.Collections.IEnumerator e = Iterator();
			while (e.MoveNext())
			{
				writer.Write("\n");
				writer.Write(index.ToString());
				writer.Write(") ");
				((Db4oUnit.Printable)e.Current).Print(writer);
				writer.Write("\n");
				++index;
			}
		}
	}
}
