/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Tests
{
	public class FrameworkTestCase : Db4oUnit.ITestCase
	{
		public static readonly System.Exception EXCEPTION = new System.Exception();

		public virtual void TestRunsGreen()
		{
			Db4oUnit.TestResult result = new Db4oUnit.TestResult();
			new Db4oUnit.Tests.RunsGreen().Run(result);
			Db4oUnit.Assert.IsTrue(result.Failures().Size() == 0, "not green");
		}

		public virtual void TestRunsRed()
		{
			Db4oUnit.TestResult result = new Db4oUnit.TestResult();
			new Db4oUnit.Tests.RunsRed(EXCEPTION).Run(result);
			Db4oUnit.Assert.IsTrue(result.Failures().Size() == 1, "not red");
		}

		public virtual void TestTestSuite()
		{
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsGreen
				() }), 0);
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsRed
				(EXCEPTION) }), 1);
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsGreen
				(), new Db4oUnit.Tests.RunsRed(EXCEPTION) }), 1);
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsRed
				(EXCEPTION), new Db4oUnit.Tests.RunsRed(EXCEPTION) }), 2);
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsRed
				(EXCEPTION), new Db4oUnit.Tests.RunsGreen() }), 1);
			RunTestAndExpect(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { new Db4oUnit.Tests.RunsGreen
				(), new Db4oUnit.Tests.RunsGreen() }), 0);
		}

		public static void RunTestAndExpect(Db4oUnit.ITest test, int expFailures)
		{
			RunTestAndExpect(test, expFailures, true);
		}

		public static void RunTestAndExpect(Db4oUnit.ITest test, int expFailures, bool checkException
			)
		{
			Db4oUnit.TestResult result = new Db4oUnit.TestResult();
			test.Run(result);
			if (expFailures != result.Failures().Size())
			{
				Db4oUnit.Assert.Fail(result.Failures().ToString());
			}
			if (checkException)
			{
				for (System.Collections.IEnumerator iter = result.Failures().Iterator(); iter.MoveNext
					(); )
				{
					Db4oUnit.TestFailure failure = (Db4oUnit.TestFailure)iter.Current;
					Db4oUnit.Assert.IsTrue(EXCEPTION.Equals(failure.GetFailure()));
				}
			}
		}
	}
}
