/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class SimplestPossibleTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleTestCase().RunSolo();
		}

		protected override void Store()
		{
			Db().Set(new Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem("one"));
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Query.IQuery q = Db().Query();
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem));
			q.Descend("name").Constrain("one");
			Db4objects.Db4o.IObjectSet objectSet = q.Execute();
			Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem item = (Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem
				)objectSet.Next();
			Db4oUnit.Assert.IsNotNull(item);
			Db4oUnit.Assert.AreEqual("one", item.GetName());
		}
	}
}
