/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Btree
{
	public class BTreeFreeTestCase : Db4objects.Db4o.Tests.Common.Btree.BTreeTestCaseBase
	{
		private static readonly int[] VALUES = new int[] { 1, 2, 5, 7, 8, 9, 12 };

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Btree.BTreeFreeTestCase().RunSolo();
		}

		public virtual void Test()
		{
			Add(VALUES);
			System.Collections.IEnumerator allSlotIDs = _btree.AllNodeIds(SystemTrans());
			Db4objects.Db4o.Foundation.Collection4 allSlots = new Db4objects.Db4o.Foundation.Collection4
				();
			while (allSlotIDs.MoveNext())
			{
				int slotID = (int)allSlotIDs.Current;
				Db4objects.Db4o.Internal.Slots.Slot slot = FileTransaction().GetCurrentSlotOfID(slotID
					);
				allSlots.Add(slot);
			}
			Db4objects.Db4o.Internal.LocalObjectContainer yapFile = (Db4objects.Db4o.Internal.LocalObjectContainer
				)Stream();
			Db4objects.Db4o.Foundation.Collection4 freedSlots = new Db4objects.Db4o.Foundation.Collection4
				();
			yapFile.InstallDebugFreespaceManager(new Db4objects.Db4o.Tests.Common.Btree.FreespaceManagerForDebug
				(yapFile, new _AnonymousInnerClass40(this, freedSlots)));
			_btree.Free(SystemTrans());
			SystemTrans().Commit();
			Db4oUnit.Assert.IsTrue(freedSlots.ContainsAll(allSlots.GetEnumerator()));
		}

		private sealed class _AnonymousInnerClass40 : Db4objects.Db4o.Tests.Common.Btree.ISlotListener
		{
			public _AnonymousInnerClass40(BTreeFreeTestCase _enclosing, Db4objects.Db4o.Foundation.Collection4
				 freedSlots)
			{
				this._enclosing = _enclosing;
				this.freedSlots = freedSlots;
			}

			public void OnFree(Db4objects.Db4o.Internal.Slots.Slot slot)
			{
				freedSlots.Add(slot);
			}

			private readonly BTreeFreeTestCase _enclosing;

			private readonly Db4objects.Db4o.Foundation.Collection4 freedSlots;
		}

		private Db4objects.Db4o.Internal.LocalTransaction FileTransaction()
		{
			return ((Db4objects.Db4o.Internal.LocalTransaction)Trans());
		}
	}
}
