/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Defragment
{
	public class Db4oDefragSolo : Db4oUnit.Extensions.Fixtures.Db4oSolo
	{
		public Db4oDefragSolo(Db4oUnit.Extensions.Fixtures.IConfigurationSource configSource
			) : base(configSource)
		{
		}

		protected override Db4objects.Db4o.IObjectContainer CreateDatabase(Db4objects.Db4o.Config.IConfiguration
			 config)
		{
			Sharpen.IO.File origFile = new Sharpen.IO.File(GetAbsolutePath());
			if (origFile.Exists())
			{
				try
				{
					string backupFile = GetAbsolutePath() + ".defrag.backup";
					Db4objects.Db4o.Defragment.IContextIDMapping mapping = new Db4objects.Db4o.Defragment.TreeIDMapping
						();
					Db4objects.Db4o.Defragment.DefragmentConfig defragConfig = new Db4objects.Db4o.Defragment.DefragmentConfig
						(GetAbsolutePath(), backupFile, mapping);
					defragConfig.ForceBackupDelete(true);
					Db4objects.Db4o.Config.IConfiguration clonedConfig = (Db4objects.Db4o.Config.IConfiguration
						)((Db4objects.Db4o.Foundation.IDeepClone)config).DeepClone(null);
					defragConfig.Db4oConfig(clonedConfig);
					Db4objects.Db4o.Defragment.Defragment.Defrag(defragConfig, new _AnonymousInnerClass32
						(this));
				}
				catch (System.IO.IOException e)
				{
					Sharpen.Runtime.PrintStackTrace(e);
				}
			}
			return base.CreateDatabase(config);
		}

		private sealed class _AnonymousInnerClass32 : Db4objects.Db4o.Defragment.IDefragmentListener
		{
			public _AnonymousInnerClass32(Db4oDefragSolo _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void NotifyDefragmentInfo(Db4objects.Db4o.Defragment.DefragmentInfo info)
			{
				Sharpen.Runtime.Err.WriteLine(info);
			}

			private readonly Db4oDefragSolo _enclosing;
		}

		public override bool Accept(System.Type clazz)
		{
			return !typeof(Db4oUnit.Extensions.Fixtures.IOptOutDefragSolo).IsAssignableFrom(clazz
				);
		}
	}
}
