/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Header
{
	public class OldHeaderTest : Db4oUnit.ITestCase
	{
		private static readonly string ORIGINAL_FILE = Db4objects.Db4o.Tests.Util.WorkspaceServices
			.WorkspaceTestFilePath("db4oVersions/db4o_5.5.2");

		private static readonly string DB_FILE = Db4objects.Db4o.Tests.Util.WorkspaceServices
			.WorkspaceTestFilePath("db4oVersions/db4o_5.5.2.yap");

		public virtual void Test()
		{
			if (!System.IO.File.Exists(ORIGINAL_FILE))
			{
				Db4oUnit.TestPlatform.EmitWarning(ORIGINAL_FILE + " does not exist. Can not run "
					 + GetType().FullName);
				return;
			}
			Db4objects.Db4o.Foundation.IO.File4.Copy(ORIGINAL_FILE, DB_FILE);
			Db4objects.Db4o.Db4oFactory.Configure().AllowVersionUpdates(true);
			Db4objects.Db4o.IObjectContainer oc = Db4objects.Db4o.Db4oFactory.OpenFile(DB_FILE
				);
			try
			{
				Db4oUnit.Assert.IsNotNull(oc);
			}
			finally
			{
				oc.Close();
				Db4objects.Db4o.Db4oFactory.Configure().AllowVersionUpdates(false);
			}
		}
	}
}
