/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public class CascadeOnActivate : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public string name;

		public Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate child;

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration conf)
		{
			conf.ObjectClass(this).CascadeOnActivate(true);
		}

		protected override void Store()
		{
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate coa = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate
				();
			coa.name = "1";
			coa.child = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate();
			coa.child.name = "2";
			coa.child.child = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate();
			coa.child.child.name = "3";
			Db().Set(coa);
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Query.IQuery q = NewQuery(GetType());
			q.Descend("name").Constrain("1");
			Db4objects.Db4o.IObjectSet os = q.Execute();
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate coa = (Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate
				)os.Next();
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnActivate coa3 = coa.child.child;
			Db4oUnit.Assert.AreEqual("3", coa3.name);
			Db().Deactivate(coa, int.MaxValue);
			Db4oUnit.Assert.IsNull(coa3.name);
			Db().Activate(coa, 1);
			Db4oUnit.Assert.AreEqual("3", coa3.name);
		}
	}
}
