/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Types.Arrays
{
	public class ByteArrayTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public interface IIByteArrayHolder
		{
			byte[] GetBytes();
		}

		[System.Serializable]
		public class SerializableByteArrayHolder : Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.IIByteArrayHolder
		{
			private const long serialVersionUID = 1L;

			internal byte[] _bytes;

			public SerializableByteArrayHolder(byte[] bytes)
			{
				this._bytes = bytes;
			}

			public virtual byte[] GetBytes()
			{
				return _bytes;
			}
		}

		public class ByteArrayHolder : Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.IIByteArrayHolder
		{
			public byte[] _bytes;

			public ByteArrayHolder(byte[] bytes)
			{
				this._bytes = bytes;
			}

			public virtual byte[] GetBytes()
			{
				return _bytes;
			}
		}

		internal const int INSTANCES = 2;

		internal const int ARRAY_LENGTH = 1024 * 512;

		#if !CF_1_0 && !CF_2_0
		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.SerializableByteArrayHolder)
				).Translate(new Db4objects.Db4o.Config.TSerializable());
		}
		#endif // !CF_1_0 && !CF_2_0

		protected override void Store()
		{
			for (int i = 0; i < INSTANCES; ++i)
			{
				Db().Set(new Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.ByteArrayHolder
					(CreateByteArray()));
				Db().Set(new Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.SerializableByteArrayHolder
					(CreateByteArray()));
			}
		}

		#if !CF_1_0 && !CF_2_0
		public virtual void TestByteArrayHolder()
		{
			TimeQueryLoop("raw byte array", typeof(Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.ByteArrayHolder)
				);
		}
		#endif // !CF_1_0 && !CF_2_0

		#if !CF_1_0 && !CF_2_0
		public virtual void TestSerializableByteArrayHolder()
		{
			TimeQueryLoop("TSerializable", typeof(Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.SerializableByteArrayHolder)
				);
		}
		#endif // !CF_1_0 && !CF_2_0

		private void TimeQueryLoop(string label, System.Type clazz)
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(clazz);
			Db4objects.Db4o.IObjectSet os = query.Execute();
			Db4oUnit.Assert.AreEqual(INSTANCES, os.Size());
			while (os.HasNext())
			{
				Db4oUnit.Assert.AreEqual(ARRAY_LENGTH, ((Db4objects.Db4o.Tests.Common.Types.Arrays.ByteArrayTestCase.IIByteArrayHolder
					)os.Next()).GetBytes().Length, label);
			}
		}

		internal virtual byte[] CreateByteArray()
		{
			byte[] bytes = new byte[ARRAY_LENGTH];
			for (int i = 0; i < bytes.Length; ++i)
			{
				bytes[i] = (byte)(i % 256);
			}
			return bytes;
		}
	}
}
