/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Btree
{
	/// <exclude></exclude>
	public class BTreeAdd : Db4objects.Db4o.Internal.Btree.BTreePatch
	{
		public BTreeAdd(Db4objects.Db4o.Internal.Transaction transaction, object obj) : base
			(transaction, obj)
		{
		}

		protected virtual object RolledBack(Db4objects.Db4o.Internal.Btree.BTree btree)
		{
			btree.NotifyRemoveListener(GetObject());
			return Db4objects.Db4o.Foundation.No4.INSTANCE;
		}

		public override string ToString()
		{
			return "(+) " + base.ToString();
		}

		public override object Commit(Db4objects.Db4o.Internal.Transaction trans, Db4objects.Db4o.Internal.Btree.BTree
			 btree)
		{
			if (_transaction == trans)
			{
				return GetObject();
			}
			return this;
		}

		public override Db4objects.Db4o.Internal.Btree.BTreePatch ForTransaction(Db4objects.Db4o.Internal.Transaction
			 trans)
		{
			if (_transaction == trans)
			{
				return this;
			}
			return null;
		}

		public override object Key(Db4objects.Db4o.Internal.Transaction trans)
		{
			if (_transaction != trans)
			{
				return Db4objects.Db4o.Foundation.No4.INSTANCE;
			}
			return GetObject();
		}

		public override object Rollback(Db4objects.Db4o.Internal.Transaction trans, Db4objects.Db4o.Internal.Btree.BTree
			 btree)
		{
			if (_transaction == trans)
			{
				return RolledBack(btree);
			}
			return this;
		}

		public override bool IsAdd()
		{
			return true;
		}
	}
}
