/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS.Messages
{
	public class MWriteBatchedMessages : Db4objects.Db4o.Internal.CS.Messages.MsgD
	{
		public sealed override bool ProcessAtServer(Db4objects.Db4o.Internal.CS.ServerMessageDispatcher
			 serverThread)
		{
			int count = ReadInt();
			Db4objects.Db4o.Internal.Transaction ta = Transaction();
			for (int i = 0; i < count; i++)
			{
				Db4objects.Db4o.Internal.StatefulBuffer writer = _payLoad.ReadYapBytes();
				int messageId = writer.ReadInt();
				Db4objects.Db4o.Internal.CS.Messages.Msg message = Db4objects.Db4o.Internal.CS.Messages.Msg
					.GetMessage(messageId);
				Db4objects.Db4o.Internal.CS.Messages.Msg clonedMessage = message.Clone(ta);
				if (clonedMessage is Db4objects.Db4o.Internal.CS.Messages.MsgD)
				{
					Db4objects.Db4o.Internal.CS.Messages.MsgD mso = (Db4objects.Db4o.Internal.CS.Messages.MsgD
						)clonedMessage;
					mso.PayLoad(writer);
					if (mso.PayLoad() != null)
					{
						mso.PayLoad().IncrementOffset(Db4objects.Db4o.Internal.Const4.MESSAGE_LENGTH - Db4objects.Db4o.Internal.Const4
							.INT_LENGTH);
						mso.PayLoad().SetTransaction(ta);
						mso.ProcessAtServer(serverThread);
					}
				}
				else
				{
					if (!clonedMessage.ProcessAtServer(serverThread))
					{
						serverThread.ProcessSpecialMsg(clonedMessage);
					}
				}
			}
			return true;
		}
	}
}
