/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	internal sealed class CustomMarshallerFieldMetadata : Db4objects.Db4o.Internal.FieldMetadata
	{
		private readonly Db4objects.Db4o.Config.IObjectMarshaller _marshaller;

		public CustomMarshallerFieldMetadata(Db4objects.Db4o.Internal.ClassMetadata containingClass
			, Db4objects.Db4o.Config.IObjectMarshaller marshaller) : base(containingClass, marshaller
			)
		{
			_marshaller = marshaller;
		}

		public override void CalculateLengths(Db4objects.Db4o.Internal.Transaction trans, 
			Db4objects.Db4o.Internal.Marshall.ObjectHeaderAttributes header, object obj)
		{
			header.AddBaseLength(LinkLength());
		}

		public override void DefragField(Db4objects.Db4o.Internal.Marshall.MarshallerFamily
			 mf, Db4objects.Db4o.Internal.ReaderPair readers)
		{
			readers.IncrementOffset(LinkLength());
		}

		public override void Delete(Db4objects.Db4o.Internal.Marshall.MarshallerFamily mf
			, Db4objects.Db4o.Internal.StatefulBuffer a_bytes, bool isUpdate)
		{
			IncrementOffset(a_bytes);
		}

		public override bool HasIndex()
		{
			return false;
		}

		public override object GetOrCreate(Db4objects.Db4o.Internal.Transaction trans, object
			 onObject)
		{
			return onObject;
		}

		public override void Set(object onObject, object obj)
		{
		}

		public override void Instantiate(Db4objects.Db4o.Internal.Marshall.MarshallerFamily
			 mf, Db4objects.Db4o.Internal.ObjectReference @ref, object onObject, Db4objects.Db4o.Internal.StatefulBuffer
			 reader)
		{
			_marshaller.ReadFields(onObject, reader._buffer, reader._offset);
			IncrementOffset(reader);
		}

		public override void Marshall(Db4objects.Db4o.Internal.ObjectReference yo, object
			 obj, Db4objects.Db4o.Internal.Marshall.MarshallerFamily mf, Db4objects.Db4o.Internal.StatefulBuffer
			 writer, Db4objects.Db4o.Internal.Config4Class config, bool isNew)
		{
			_marshaller.WriteFields(obj, writer._buffer, writer._offset);
			IncrementOffset(writer);
		}

		public override int LinkLength()
		{
			return _marshaller.MarshalledFieldLength();
		}
	}
}
