/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Handlers
{
	/// <exclude></exclude>
	public abstract class NetTypeHandler : Db4objects.Db4o.Internal.Handlers.PrimitiveHandler
		, Db4objects.Db4o.Internal.Handlers.INetType
	{
		public NetTypeHandler(Db4objects.Db4o.Internal.ObjectContainerBase stream) : base
			(stream)
		{
		}

		private int i_linkLength;

		private object i_compareTo;

		public abstract int Compare(object compare, object with);

		public virtual string DotNetClassName()
		{
			string className = this.GetType().FullName;
			int pos = className.IndexOf(".Net");
			if (pos >= 0)
			{
				return "System." + Sharpen.Runtime.Substring(className, pos + 4) + ", mscorlib";
			}
			return DefaultValue().GetType().FullName;
		}

		public abstract bool IsEqual(object compare, object with);

		public virtual void Initialize()
		{
			byte[] bytes = new byte[65];
			for (int i = 0; i < bytes.Length; i++)
			{
				bytes[i] = 55;
			}
			Write(PrimitiveNull(), bytes, 0);
			for (int i = 0; i < bytes.Length; i++)
			{
				if (bytes[i] == 55)
				{
					i_linkLength = i;
					break;
				}
			}
		}

		public override int GetID()
		{
			return TypeID();
		}

		public virtual string GetName()
		{
			return DotNetClassName();
		}

		public override int LinkLength()
		{
			return i_linkLength;
		}

		protected override System.Type PrimitiveJavaClass()
		{
			return null;
		}

		public override object PrimitiveNull()
		{
			return DefaultValue();
		}

		public abstract object Read(byte[] bytes, int offset);

		internal override object Read1(Db4objects.Db4o.Internal.Buffer a_bytes)
		{
			int offset = a_bytes._offset;
			object ret = Read(a_bytes._buffer, a_bytes._offset);
			a_bytes._offset = offset + LinkLength();
			return ret;
		}

		public abstract int TypeID();

		public abstract void Write(object obj, byte[] bytes, int offset);

		public override void Write(object a_object, Db4objects.Db4o.Internal.Buffer a_bytes
			)
		{
			int offset = a_bytes._offset;
			if (a_object != null)
			{
				Write(a_object, a_bytes._buffer, a_bytes._offset);
			}
			a_bytes._offset = offset + LinkLength();
		}

		internal override void PrepareComparison1(object obj)
		{
			i_compareTo = obj;
		}

		public override object Current1()
		{
			return i_compareTo;
		}

		internal override bool IsEqual1(object obj)
		{
			return IsEqual(i_compareTo, obj);
		}

		internal override bool IsGreater1(object obj)
		{
			if (ClassReflector().IsInstance(obj) && !IsEqual(i_compareTo, obj))
			{
				return Compare(i_compareTo, obj) > 0;
			}
			return false;
		}

		internal override bool IsSmaller1(object obj)
		{
			if (ClassReflector().IsInstance(obj) && !IsEqual(i_compareTo, obj))
			{
				return Compare(i_compareTo, obj) < 0;
			}
			return false;
		}
	}
}
