/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.IX
{
	/// <summary>Node for index tree, can be addition or removal node</summary>
	public abstract class IxPatch : Db4objects.Db4o.Internal.IX.IxTree
	{
		internal int _parentID;

		internal object _value;

		private Db4objects.Db4o.Foundation.Queue4 _queue;

		internal IxPatch(Db4objects.Db4o.Internal.IX.IndexTransaction a_ft, int a_parentID
			, object a_value) : base(a_ft)
		{
			_parentID = a_parentID;
			_value = a_value;
		}

		public override Db4objects.Db4o.Foundation.Tree Add(Db4objects.Db4o.Foundation.Tree
			 a_new)
		{
			int cmp = Compare(a_new);
			if (cmp == 0)
			{
				Db4objects.Db4o.Internal.IX.IxPatch patch = (Db4objects.Db4o.Internal.IX.IxPatch)
					a_new;
				cmp = _parentID - patch._parentID;
				if (cmp == 0)
				{
					Db4objects.Db4o.Foundation.Queue4 queue = _queue;
					if (queue == null)
					{
						queue = new Db4objects.Db4o.Foundation.Queue4();
						queue.Add(this);
					}
					queue.Add(patch);
					patch._queue = queue;
					patch._subsequent = _subsequent;
					patch._preceding = _preceding;
					patch.CalculateSize();
					return patch;
				}
			}
			return Add(a_new, cmp);
		}

		public override int Compare(Db4objects.Db4o.Foundation.Tree a_to)
		{
			Db4objects.Db4o.Internal.IX.IIndexable4 handler = _fieldTransaction.i_index._handler;
			return handler.CompareTo(handler.ComparableObject(Trans(), _value));
		}

		public virtual bool HasQueue()
		{
			return _queue != null;
		}

		public virtual Db4objects.Db4o.Foundation.Queue4 DetachQueue()
		{
			Db4objects.Db4o.Foundation.Queue4 queue = _queue;
			this._queue = null;
			return queue;
		}

		protected override Db4objects.Db4o.Foundation.Tree ShallowCloneInternal(Db4objects.Db4o.Foundation.Tree
			 tree)
		{
			Db4objects.Db4o.Internal.IX.IxPatch patch = (Db4objects.Db4o.Internal.IX.IxPatch)
				base.ShallowCloneInternal(tree);
			patch._parentID = _parentID;
			patch._value = _value;
			patch._queue = _queue;
			return patch;
		}
	}
}
