/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Mapping
{
	/// <summary>Encapsulates services involving source and target database files during defragmenting.
	/// 	</summary>
	/// <remarks>Encapsulates services involving source and target database files during defragmenting.
	/// 	</remarks>
	/// <exclude></exclude>
	public interface IDefragContext : Db4objects.Db4o.Internal.Mapping.IIDMapping
	{
		Db4objects.Db4o.Internal.Buffer SourceReaderByAddress(int address, int length);

		Db4objects.Db4o.Internal.Buffer TargetReaderByAddress(int address, int length);

		Db4objects.Db4o.Internal.Buffer SourceReaderByID(int sourceID);

		int AllocateTargetSlot(int targetLength);

		void TargetWriteBytes(Db4objects.Db4o.Internal.Buffer targetPointerReader, int targetID
			);

		Db4objects.Db4o.Internal.Transaction SystemTrans();

		void TargetWriteBytes(Db4objects.Db4o.Internal.ReaderPair readers, int targetAddress
			);

		void TraverseAllIndexSlots(Db4objects.Db4o.Internal.Btree.BTree tree, Db4objects.Db4o.Foundation.IVisitor4
			 visitor4);

		Db4objects.Db4o.Internal.ClassMetadata YapClass(int id);

		Db4objects.Db4o.Internal.StatefulBuffer SourceWriterByID(int sourceID);

		int MappedID(int id, bool lenient);

		void RegisterUnindexed(int id);

		System.Collections.IEnumerator UnindexedIDs();
	}
}
