/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Query.Result
{
	/// <exclude></exclude>
	public class HybridQueryResult : Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult
	{
		private Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult _delegate;

		public HybridQueryResult(Db4objects.Db4o.Internal.Transaction transaction, Db4objects.Db4o.Config.QueryEvaluationMode
			 mode) : base(transaction)
		{
			_delegate = ForMode(transaction, mode);
		}

		private static Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult ForMode(
			Db4objects.Db4o.Internal.Transaction transaction, Db4objects.Db4o.Config.QueryEvaluationMode
			 mode)
		{
			if (mode == Db4objects.Db4o.Config.QueryEvaluationMode.LAZY)
			{
				return new Db4objects.Db4o.Internal.Query.Result.LazyQueryResult(transaction);
			}
			if (mode == Db4objects.Db4o.Config.QueryEvaluationMode.SNAPSHOT)
			{
				return new Db4objects.Db4o.Internal.Query.Result.SnapShotQueryResult(transaction);
			}
			return new Db4objects.Db4o.Internal.Query.Result.IdListQueryResult(transaction);
		}

		public override object Get(int index)
		{
			_delegate = _delegate.SupportElementAccess();
			return _delegate.Get(index);
		}

		public override int GetId(int index)
		{
			_delegate = _delegate.SupportElementAccess();
			return _delegate.GetId(index);
		}

		public override int IndexOf(int id)
		{
			_delegate = _delegate.SupportElementAccess();
			return _delegate.IndexOf(id);
		}

		public override Db4objects.Db4o.Foundation.IIntIterator4 IterateIDs()
		{
			return _delegate.IterateIDs();
		}

		public override System.Collections.IEnumerator GetEnumerator()
		{
			return _delegate.GetEnumerator();
		}

		public override void LoadFromClassIndex(Db4objects.Db4o.Internal.ClassMetadata clazz
			)
		{
			_delegate.LoadFromClassIndex(clazz);
		}

		public override void LoadFromClassIndexes(Db4objects.Db4o.Internal.ClassMetadataIterator
			 iterator)
		{
			_delegate.LoadFromClassIndexes(iterator);
		}

		public override void LoadFromIdReader(Db4objects.Db4o.Internal.Buffer reader)
		{
			_delegate.LoadFromIdReader(reader);
		}

		public override void LoadFromQuery(Db4objects.Db4o.Internal.Query.Processor.QQuery
			 query)
		{
			if (query.RequiresSort())
			{
				_delegate = new Db4objects.Db4o.Internal.Query.Result.IdListQueryResult(Transaction
					());
			}
			_delegate.LoadFromQuery(query);
		}

		public override int Size()
		{
			_delegate = _delegate.SupportSize();
			return _delegate.Size();
		}

		public override void Sort(Db4objects.Db4o.Query.IQueryComparator cmp)
		{
			_delegate = _delegate.SupportSort();
			_delegate.Sort(cmp);
		}
	}
}
