/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Nativequery.Expr.Cmp
{
	public class FieldValue : Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperandDescendant
	{
		private string _fieldName;

		private object _tag;

		public FieldValue(Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperandAnchor root
			, string name) : this(root, name, null)
		{
		}

		public FieldValue(Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperandAnchor root
			, string name, object tag) : base(root)
		{
			_fieldName = name;
			_tag = tag;
		}

		public virtual string FieldName()
		{
			return _fieldName;
		}

		public override bool Equals(object other)
		{
			if (!base.Equals(other))
			{
				return false;
			}
			Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue casted = (Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue
				)other;
			if (_tag == null)
			{
				if (casted._tag != null)
				{
					return false;
				}
			}
			else
			{
				if (!_tag.Equals(casted._tag))
				{
					return false;
				}
			}
			return _fieldName.Equals(casted._fieldName);
		}

		public override int GetHashCode()
		{
			int hash = base.GetHashCode() * 29 + _fieldName.GetHashCode();
			if (_tag != null)
			{
				hash *= 29 + _tag.GetHashCode();
			}
			return hash;
		}

		public override string ToString()
		{
			return base.ToString() + "." + _fieldName;
		}

		public override void Accept(Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperandVisitor
			 visitor)
		{
			visitor.Visit(this);
		}

		/// <summary>Code analysis specific information.</summary>
		/// <remarks>
		/// Code analysis specific information.
		/// This is used in the .net side to preserve Mono.Cecil references
		/// for instance.
		/// </remarks>
		public virtual object Tag()
		{
			return _tag;
		}

		public virtual void Tag(object value)
		{
			_tag = value;
		}
	}
}
