/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using Db4objects.Db4o.Reflect;
using Sharpen.Lang;

#if CF_1_0
// not need for CF_2_0
namespace System.Runtime.CompilerServices
{
	internal class IsVolatile
	{
	}
}

namespace System
{
	class NotImplementedException : Exception
	{
		internal NotImplementedException ()
		{
		}

		internal NotImplementedException (string message) : base (message)
		{
		}
	}

	class CompactFramework1Console
	{
		private static TextWriter _out = new DebugTextWriter();

		private static TextWriter _error = new DebugTextWriter();

		public static TextWriter Out
		{
			get
			{
				return _out;
			}
			set
			{
				_out = value;
			}
		}

		public static TextWriter Error
		{
			get
			{
				return _error;
			}
			set
			{
				_error = value;
			}
		}
	}
}

namespace System.IO
{
	class DebugTextWriter : TextWriter
	{
		public override System.Text.Encoding Encoding
		{
			get { return System.Text.Encoding.UTF8; }
		}

		public override void Write(string s)
		{
			Debug.Write(s);
		}

		public override void WriteLine(string s)
		{
			Debug.WriteLine(s);
		}
	}
}

#endif

#if CF_1_0 || CF_2_0
namespace System
{
	class SerializableAttribute : Attribute
	{
	}
}

namespace Db4objects.Db4o
{
	/// <exclude />
	public class Compat
	{
	}
}
#endif