/* Copyright (C) 2004-2007   db4objects Inc.   http://www.db4o.com */

package db4ounit.extensions.tests;

import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.query.Query;

import db4ounit.Assert;
import db4ounit.extensions.AbstractDb4oTestCase;


public class CascadeOnUpdate extends AbstractDb4oTestCase {
	
	public static class Atom {
		
		public Atom child;
		public String name;
		
		public Atom(){
		}
		
		public Atom(Atom child){
			this.child = child;
		}
		
		public Atom(String name){
			this.name = name;
		}
		
		public Atom(Atom child, String name){
			this(child);
			this.name = name;
		}
	}
	// end Atom

	public Object child;

	protected void configure(Configuration conf) {
		conf.objectClass(Atom.class).cascadeOnUpdate(false);
	}
	// end configure

	protected void store() {
		Atom atom = new Atom(new Atom(new Atom("storedGrandChild"), "storedChild"),"parent");
		db().set(atom);
		db().commit();
	}
	// end store

	public void test() throws Exception {
		Query q = newQuery(Atom.class);
		q.descend("name").constrain("parent");
		ObjectSet objectSet = q.execute();
		Atom atom = null;
		while (objectSet.hasNext()){
			// update child objects
			atom = (Atom)objectSet.next();
			((Atom)atom.child).name = "updated";
			((Atom)atom.child).child.name = "notUpdated";
			// store the parent object
			db().set(atom);
		}
		
		// commit and refresh to make sure that the changes are saved
		// and reference cash is refreshed
		db().commit();
		db().refresh(atom, Integer.MAX_VALUE);
		
		
		q = newQuery(Atom.class);
		q.descend("name").constrain("parent");
		objectSet = q.execute();
		while(objectSet.hasNext()){
			atom = (Atom) objectSet.next();
			Atom child = (Atom)atom.child;
			// check if the child objects were updated
			Assert.areEqual("updated", child.name);
			Assert.areNotEqual("updated", child.child.name);
		}
	}
	// end test
}
