' Copyright (C) 2004 - 2007 db4objects Inc. http:'www.db4o.com 
Imports System
Imports System.IO
Imports Interfaces

Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config
Imports Db4objects.Db4o.Ext
Imports Db4objects.Db4o.Query

'ITest interface implementation.
'Test object will be referenced from the client and saved to the database
'on the server side.

Namespace Server

    Public Class Test
        Inherits MarshalByRefObject
        Implements Interfaces.Interfaces.ITest

        Private _data As String

        Private Const Db4oFileName As String = "reference.db4o"

        Public Function GetData() As String Implements Interfaces.Interfaces.ITest.GetData
            Return _data
        End Function
        ' end GetData

        Public Sub ChangeData(ByVal data As String) Implements Interfaces.Interfaces.ITest.ChangeData
            _data = data
        End Sub
        ' end ChangeData

        Public Sub StoreData() Implements Interfaces.Interfaces.ITest.StoreData
            ' store the current object to the database
            File.Delete(Db4oFileName)
            Dim db As IObjectContainer = Database()
            Try
                db.Set(Me)
                db.Commit()
            Catch ex As Exception
                System.Console.WriteLine(ex.Message)
            Finally
                db.Close()
            End Try
        End Sub
        ' end StoreData

        Public Function RetrieveData() As String Implements Interfaces.Interfaces.ITest.RetrieveData
            ' retrieve Test object from the database
            ' and return its data to the client
            ' If the object cannot be retrieved return
            ' "No results" to the client
            Dim db As IObjectContainer = Database()
            Try
                Dim result As IObjectSet = db.Query(GetType(Test))
                System.Console.WriteLine(result.Count)
                If result.Count > 0 Then
                    Return CType(result.Next(), Test).GetData()
                End If

            Catch ex As Exception
                System.Console.WriteLine(ex.Message)
            Finally
                db.Close()
            End Try
            Return "No results"
        End Function
        ' end RetrieveData

        Private Shared Function Configure() As IConfiguration
            ' create configuration to allow MarshalByRef objects to be stored
            Dim conf As IConfiguration = Db4oFactory.NewConfiguration()
            conf.ObjectClass("System.Runtime.Remoting.ServerIdentity, mscorlib").Translate(New TTransient())
            conf.ObjectClass("System.Threading.TimerCallback, mscorlib").Translate(New TTransient())
            Return conf
        End Function
        ' end Configure

        Private Shared Function Database() As IObjectContainer
            ' get database connection
            Dim configuration As IConfiguration = Configure()
            Dim container As IObjectContainer = Nothing
            Try
                container = Db4oFactory.OpenFile(configuration, Db4oFileName)
            Catch ex As DatabaseFileLockedException
                System.Console.WriteLine(ex.Message)
            End Try
            Return container
        End Function
        ' end Database
    End Class
End Namespace
