/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.TA;

namespace Db4objects.Db4o.TA
{
	/// <summary>Enables the Transparent Update and Transparent Activation behaviors.</summary>
	/// <remarks>Enables the Transparent Update and Transparent Activation behaviors.</remarks>
	public class TransparentPersistenceSupport : IConfigurationItem
	{
		private readonly IRollbackStrategy _rollbackStrategy;

		public TransparentPersistenceSupport(IRollbackStrategy rollbackStrategy)
		{
			_rollbackStrategy = rollbackStrategy;
		}

		public TransparentPersistenceSupport() : this(null)
		{
		}

		public virtual void Apply(IInternalObjectContainer container)
		{
		}

		public virtual void Prepare(IConfiguration configuration)
		{
			configuration.Add(new TransparentActivationSupport());
		}

		public virtual void Rollback(IObjectContainer container, object obj)
		{
			if (null == _rollbackStrategy)
			{
				return;
			}
			_rollbackStrategy.Rollback(container, obj);
		}
	}
}
