#!/usr/bin/env bash

pglibdir=/usr/local/pgsql/lib/
mylibdir=/usr/local/lib/mysql/

pgincdir=/usr/local/pgsql/include/
myincdir=/usr/include/mysql/

pglibs="-lpq -lcrypto -lssl -lz"
mylibs="-lmysqlclient -lcrypto -lz"

bindir=/usr/local/sbin

echo This is the dbmail build script
echo I will have to ask you some questions about your system
echo ""

if [ "$1" != "" ]; then
    database=$1
else
    echo What database do you wish to use? Choices are \(m\)ysql and \(p\)ostgresql \>
    read database
fi

if [ "$database" = p ]; then
    echo You have selected PostgreSQL as database
    # see if we can find pg_config to grab the build options
    # N.B. we can't determine pglibs from pg_config so this is still hardcoded.
    for i in /usr/local/pgsql/bin /usr/local/postgres/bin /opt/pgsql/bin /usr/local/bin /usr/local/sbin /usr/bin /usr/sbin;
        do
        if [ -x $i/pg_config ]; then
            version=`$i/pg_config --version|awk '{print $2}'`
            if [ -n "$pg_config" ]; then
                # we've found more than one 
                if [ -n "$pg_configs" ]; then
                    pg_configs="$version:$i/pg_config $pg_configs"
                else
                    pg_configs="$version:$i/pg_config $pg_config"
                fi
            fi    
            pg_config="$version:$i/pg_config"
        fi
    done
    if [ -n "$pg_configs" ]; then
        # sort the list
        pg_configs=`echo $pg_configs|tr ' ' '\n' | sort `
        echo Found multiple versions of pg_config:
        echo $pg_configs|tr ' ' '\n'|sed -e 's/^/PostgreSQL /'
        pg_config=`echo $pg_configs|tr ' ' '\n'|tail -n 1|awk -F : '{print $2}'`
        echo Enter your preferred version or press RETURN to use [$pg_config]:
        read line
        if [ "$line" != "" ]; then
            pg_config=$line
        fi
    else
        pg_config=`echo $pg_config|awk -F : '{print $2}'`
    fi
    if [ -x $pg_config ]; then
        pglibdir=`$pg_config --libdir`
        pgincdir=`$pg_config --includedir`
    fi
    
    libdir=$pglibdir
    incdir=$pgincdir
    libs=$pglibs
    dbtype=PostgreSQL
    db=pgsql
else
    echo You have selected MySQL as database
    # try using mysql_config to determine build options
    for i in /usr/local/mysql/bin /opt/mysql/bin /usr/local/bin /usr/local/sbin /usr/bin /usr/sbin;
        do
        if [ -x $i/mysql_config ]; then
            version=`$i/mysql_config --version`
            if [ -n "$mysql_config" ]; then
                # we've found more than one 
                if [ -n "$mysql_configs" ]; then
                    mysql_configs="$version:$i/mysql_config $mysql_configs"
                else
                    mysql_configs="$version:$i/mysql_config $mysql_config"
                fi
            fi    
            mysql_config="$version:$i/mysql_config"
        fi
    done
    if [ -n "$mysql_configs" ]; then
        # sort the list
        mysql_configs=`echo $mysql_configs|tr ' ' '\n' | sort `
        echo Found multiple versions of mysql_config:
        echo $mysql_configs|tr ' ' '\n'|sed -e 's/^/MySQL /'
        mysql_config=`echo $mysql_configs|tr ' ' '\n'|tail -n 1|awk -F : '{print $2}'`
        echo Enter your preferred version or press RETURN to use [$mysql_config]:
        read line
        if [ "$line" != "" ]; then
            mysql_config=$line
        fi
    else
        mysql_config=`echo $mysql_config|awk -F : '{print $2}'`
    fi
    if [ -x $mysql_config ]; then
        mylibdir=`$mysql_config --libs | awk -F \' '{print $2}'`
        myincdir=`$mysql_config --cflags | awk -F \' '{print $2}'`
        mylibs=`$mysql_config --libs|sed -e 's/^.*-lmysqlclient /-lmysqlclient /'`
    fi
    libdir=$mylibdir
    incdir=$myincdir
    libs=$mylibs
    dbtype=MySQL
    db=mysql
fi

echo The library directory for $dbtype is now \[$libdir\]. 
echo Enter new directory or press RETURN to keep this setting:
read line
if [ "$line" != "" ]; then
    libdir=$line
fi

echo The include directory for $dbtype is now \[$incdir\]. 
echo Enter new directory or press RETURN to keep this setting:
read line
if [ "$line" != "" ]; then	
    incdir=$line
fi


echo The libraries are currently set to \[$libs\]. 
echo Enter new libraries \(preceed each by \-l\) or press RETURN to keep this setting:
read line
if [ "$line" != "" ]; then
    libs=$line
fi

# This is poor, but there's no easy way to check for a header file
# (that's what the autoconf system is for)
if [ -f /usr/include/endian.h ] || [ -f "${incdir}/endian.h" ]; then
    cflags="$cflags -DHAVE_ENDIAN_H"
fi
if [ -f /usr/include/crypt.h ] || [ -f "${incdir}/crypt.h" ]; then
    cflags="$cflags -DHAVE_CRYPT_H"
fi

echo ""
echo Creating makefile..

cat >Makefile <<EOF
#!/usr/bin/env bash

#
# Auto-generated Makefile for $dbtype
#

__DBTYPE__=$db
__LIBS__=$libs
__LIBDIR__=$libdir
__INCDIR__=$incdir -I.
__CFLAGS__=$cflags

EOF

cat Makefile.concept >>Makefile

echo ""
echo Done. You can now make dbmail by running \'make clean all\'.
echo Do you want this to be executed right now [y/N]?
read line

if [ "$line" = y ]; then
    make clean all

    if [ $? -eq 0 ]; then
	echo ""
	echo Make succesfull. Do you want to install the binaries and man pages? [y/N]
	read line

	if [ "$line" = y ]; then
	    echo Target binary directory is now $bindir. 
	    echo Enter new directory or press RETURN to keep this setting:
	    read line

	    if [ "$line" != "" ]; then
		bindir=$line
	    fi
	    
	    ./install-dbmail.sh $bindir
	    if [ $? -ne 0 ]; then
		echo install script failed. You can rerun this manually by running install-dbmail.sh
		exit 1
	    fi

	else
	    echo Note: You can install the files manually by running install-dbmail.sh
	fi
    else
	echo Sorry, Make failed. 
	echo Please report any problems to the mailing list: dbmail@dbmail.org
	echo You can find more information \(including how to subscribe to the mailinglist\) on www.dbmail.org
    fi

fi


