/* Distributed Checksum Clearinghouse
 *
 * internal checksumming definitions
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.15 $Revision$
 */

#ifndef CK_H
#define CK_H

#include "dcc_defs.h"
#include "dcc_ck.h"

extern u_int dcc_ck_qp_decode(DCC_GOT_CKS *, const char **, u_int *,
			      char *, u_int);
extern u_int dcc_ck_b64_decode(DCC_GOT_CKS *, const char **, u_int *,
			       char *, u_int);

extern int dcc_ck_url(DCC_URL_SKIP *, char, char **);
#define DCC_CK_URL_CHAR	    0x0000
#define DCC_CK_URL_CK_LEN   0x0100
#define DCC_CK_URL_HOST	    0x0200
#define DCC_CK_URL_SKIP	    0x0300
#define DCC_CK_URL_MASK	    0xff00

extern void dcc_ck_fuz1_init(DCC_GOT_CKS *);
extern void dcc_ck_fuz1(DCC_GOT_CKS *, const char *, u_int);
extern void dcc_ck_fuz1_fin(DCC_GOT_CKS *);

extern void dcc_ck_fuz2_init(DCC_GOT_CKS *);
extern void dcc_ck_fuz2(DCC_GOT_CKS *, const char *, u_int);
extern void dcc_ck_fuz2_fin(DCC_GOT_CKS *);

#endif /* CK_H */
